/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.installation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.maven.plugin.MojoExecutionException;

public class TarUnArchiver {
    private File archive;

    public TarUnArchiver(File archive) {
        this.archive = archive;
    }

    public void unarchive(String baseDir) throws MojoExecutionException {
        try {
            FileInputStream fis = new FileInputStream(this.archive);
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)fis));
            TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
            while (tarEntry != null) {
                File destPath = new File(baseDir + File.separator + tarEntry.getName());
                if (tarEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    destPath.createNewFile();
                    destPath.setExecutable(true);
                    byte[] btoRead = new byte[8024];
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));
                    int len = 0;
                    while ((len = tarIn.read(btoRead)) != -1) {
                        bout.write(btoRead, 0, len);
                    }
                    bout.close();
                }
                tarEntry = tarIn.getNextTarEntry();
            }
            tarIn.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not extract archive: '" + this.archive.getAbsolutePath() + "'", (Exception)e);
        }
    }
}

