/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.mojo;

import io.wcm.maven.plugins.nodejs.installation.NodeInstallationInformation;
import io.wcm.maven.plugins.nodejs.installation.NodeUnarchiveTask;
import io.wcm.maven.plugins.nodejs.installation.NpmUnarchiveTask;
import io.wcm.maven.plugins.nodejs.mojo.NpmInstallTask;
import io.wcm.maven.plugins.nodejs.mojo.Task;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;

public abstract class AbstractNodeJsMojo
extends AbstractMojo {
    @Parameter(property="nodejs.version", defaultValue="0.12.0")
    protected String nodeJsVersion;
    @Parameter(property="nodejs.npm.version", defaultValue="2.5.1")
    protected String npmVersion;
    @Parameter(property="nodejs.directory", defaultValue="${java.io.tmpdir}/nodejs")
    protected File nodeJsDirectory;
    @Parameter
    protected List<? extends Task> tasks;
    @Parameter(defaultValue="true")
    protected boolean stopOnError;
    @Parameter(property="nodejs.skip")
    protected boolean skip;
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;

    public void run() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if (this.tasks == null || this.tasks.isEmpty()) {
            this.getLog().warn((CharSequence)"No Node.jsTasks have been defined. Nothing to do");
        }
        NodeInstallationInformation information = this.getOrInstallNodeJS();
        if (this.tasks != null) {
            for (Task task : this.tasks) {
                task.setLog(this.getLog());
                task.execute(information);
            }
        }
    }

    private NodeInstallationInformation getOrInstallNodeJS() throws MojoExecutionException {
        NodeInstallationInformation information;
        block9: {
            information = NodeInstallationInformation.forVersion(this.nodeJsVersion, this.npmVersion, this.nodeJsDirectory);
            try {
                if (!information.getNodeExecutable().exists() || !information.getNpmExecutable().exists()) {
                    if (!this.cleanBaseDirectory()) {
                        throw new MojoExecutionException("Could not delete node js directory: " + this.nodeJsDirectory);
                    }
                    File nodeJsBinary = this.resolveArtifact(information.getNodeJsDependency());
                    FileUtils.copyFile((File)nodeJsBinary, (File)information.getArchive());
                    if (information.getArchive().getName().endsWith(".tar.gz")) {
                        NodeUnarchiveTask installationTask = new NodeUnarchiveTask(this.nodeJsDirectory.getAbsolutePath());
                        installationTask.setLog(this.getLog());
                        ((Task)installationTask).execute(information);
                    }
                    if (Os.isFamily((String)"windows") || Os.isFamily((String)"win9x")) {
                        this.installNPM(information);
                    }
                }
                if (!this.specifiedNPMIsInstalled()) {
                    this.updateNPMExecutable(information);
                }
            }
            catch (MalformedURLException ex) {
                throw new MojoExecutionException("Malformed provided node URL", (Exception)ex);
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("Failed to get nodeJs from " + information.getNodeJsDependency()), (Throwable)ex);
                throw new MojoExecutionException("Failed to downloading nodeJs from " + information.getNodeJsDependency(), (Exception)ex);
            }
            catch (MojoExecutionException ex) {
                this.getLog().error((CharSequence)"Execution Exception", (Throwable)ex);
                if (!this.stopOnError) break block9;
                throw new MojoExecutionException("Execution Exception", (Exception)((Object)ex));
            }
        }
        NodeInstallationInformation.setSpecifiedNpmExecutable(information, this.nodeJsDirectory);
        return information;
    }

    private boolean specifiedNPMIsInstalled() {
        return new File(this.nodeJsDirectory.getAbsolutePath() + File.separator + "node_modules/npm/bin/npm-cli.js").exists();
    }

    private boolean cleanBaseDirectory() {
        if (this.nodeJsDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.nodeJsDirectory);
            }
            catch (IOException ex) {
                this.getLog().error((Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private void updateNPMExecutable(NodeInstallationInformation information) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Installing specified npm version " + this.npmVersion));
        NpmInstallTask npmInstallTask = new NpmInstallTask();
        npmInstallTask.setLog(this.getLog());
        npmInstallTask.setArguments(new String[]{"--prefix", this.nodeJsDirectory.getAbsolutePath(), "npm@" + this.npmVersion});
        npmInstallTask.execute(information);
    }

    private void installNPM(NodeInstallationInformation information) throws IOException, MojoExecutionException {
        File npmBinary = this.resolveArtifact(information.getNpmDependency());
        FileUtils.copyFile((File)npmBinary, (File)information.getNpmArchive());
        NpmUnarchiveTask installationTask = new NpmUnarchiveTask(this.nodeJsDirectory.getAbsolutePath() + File.separator + "v-" + this.nodeJsVersion);
        installationTask.setLog(this.getLog());
        ((Task)installationTask).execute(information);
    }

    private File resolveArtifact(Dependency dependency) throws MojoExecutionException {
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), "provided", dependency.getType(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()));
        try {
            this.resolver.resolve((Artifact)artifact, this.project.getRemoteArtifactRepositories(), this.session.getLocalRepository());
        }
        catch (ArtifactResolutionException ex) {
            throw new MojoExecutionException("Unable to get artifact for " + dependency, (Exception)((Object)ex));
        }
        catch (ArtifactNotFoundException ex) {
            throw new MojoExecutionException("Unable to get artifact for " + dependency, (Exception)((Object)ex));
        }
        return artifact.getFile();
    }
}

