/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.mojo;

import io.wcm.maven.plugins.nodejs.installation.NodeInstallationInformation;
import io.wcm.maven.plugins.nodejs.mojo.NpmInstallTask;
import io.wcm.maven.plugins.nodejs.mojo.Task;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public class NodeJsTask
extends Task {
    @Parameter
    private String moduleName;
    @Parameter
    private String executableName;
    @Parameter
    private String moduleVersion;
    @Parameter
    private String[] arguments;

    @Override
    protected List<String> getCommand(NodeInstallationInformation information) throws MojoExecutionException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(information.getNodeExecutable().getAbsolutePath());
        this.setNodeModule(commands, information);
        if (this.arguments != null) {
            commands.addAll(Arrays.asList(this.arguments));
        }
        return commands;
    }

    private void setNodeModule(List<String> commands, NodeInstallationInformation information) throws MojoExecutionException {
        String modulePath = this.installModule(information);
        String moduleExecutable = this.getModuleExecutable(modulePath);
        commands.add(moduleExecutable);
    }

    private String installModule(NodeInstallationInformation information) throws MojoExecutionException {
        String modulePath = "";
        String localInstallationPath = this.workingDirectory.getAbsolutePath() + File.separator + "node_modules" + File.separator + this.moduleName;
        File localInstallation = new File(localInstallationPath);
        if (!localInstallation.exists()) {
            String globalInstallationPath = information.getBasePath() + "node_modules" + File.separator + this.moduleName;
            File moduleInstallation = new File(globalInstallationPath);
            if (!moduleInstallation.exists()) {
                NpmInstallTask installTask = new NpmInstallTask();
                installTask.setLog(this.getLog());
                installTask.setArguments(new String[]{"--prefix", information.getBasePath(), this.moduleName});
                installTask.execute(information);
            }
            modulePath = globalInstallationPath;
        } else {
            modulePath = localInstallationPath;
        }
        return modulePath;
    }

    private String getModuleExecutable(String modulePath) {
        String executable = this.executableName == null ? this.moduleName : this.executableName;
        return modulePath + File.separator + "bin" + File.separator + executable;
    }
}

