/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.dotnotes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.zackehh.dotnotes.DotUtils;
import com.zackehh.dotnotes.NotedKey;
import com.zackehh.dotnotes.ParseException;
import java.util.ArrayList;
import java.util.List;

public class DotNotes {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;

    private DotNotes() {
        throw new UnsupportedOperationException();
    }

    public static JsonNode create(JsonNode target, String path, JsonNode value) throws ParseException {
        List<NotedKey> keys = DotNotes.keys(path);
        NotedKey first = keys.get(0);
        if (target == null) {
            Object object = target = first.isNumber() ? factory.arrayNode() : factory.objectNode();
        }
        if (first.isNumber() && !target.isArray()) {
            throw new ParseException("Expected ArrayNode target for create call!");
        }
        if (first.isString() && !target.isObject()) {
            throw new ParseException("Expected ObjectNode target for create call!");
        }
        JsonNode tmp = target;
        int lastIndex = keys.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            NotedKey key = keys.get(i);
            JsonNode local = DotUtils.findNode(tmp, key);
            if (local.isMissingNode()) {
                DotUtils.set(tmp, key, (JsonNode)(keys.get(i + 1).isNumber() ? factory.arrayNode() : factory.objectNode()));
            }
            tmp = DotUtils.findNode(tmp, key);
        }
        NotedKey endKey = keys.get(lastIndex);
        DotUtils.set(tmp, endKey, value);
        return target;
    }

    public static String escape(NotedKey key) throws ParseException {
        if (key == null) {
            throw new ParseException("Unexpected non-string value provided!");
        }
        if (key.isNumber()) {
            return "[" + key.asNumber() + "]";
        }
        String input = key.asString();
        if (!DotUtils.matches(input, DotUtils.ACCESSOR)) {
            return "[\"" + input.replace("\"", "\\\"") + "\"]";
        }
        return input;
    }

    public static String escape(Number num) throws ParseException {
        return DotNotes.escape(NotedKey.of(num));
    }

    public static String escape(String str) throws ParseException {
        return DotNotes.escape(NotedKey.of(str));
    }

    public static JsonNode get(JsonNode node, String path) throws ParseException {
        if (node == null) {
            return MissingNode.getInstance();
        }
        List<NotedKey> keys = DotNotes.keys(path);
        JsonNode tmp = node;
        int lastIndex = keys.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (!(tmp = DotUtils.findNode(tmp, keys.get(i))).isMissingNode() && !tmp.isNull()) continue;
            return MissingNode.getInstance();
        }
        NotedKey key = keys.get(lastIndex);
        if (key.isNumber()) {
            return tmp.path(key.asNumber().intValue());
        }
        return tmp.path(key.asString());
    }

    public static boolean isEscaped(String key) {
        return key != null && DotUtils.matches(key, DotUtils.KEY);
    }

    public static List<NotedKey> keys(String s) throws ParseException {
        if (s == null || s.isEmpty()) {
            throw new ParseException("Unable to parse empty string!");
        }
        int position = 0;
        ArrayList<NotedKey> keys = new ArrayList<NotedKey>();
        String input = s;
        while (!input.isEmpty()) {
            String remainder;
            String prop = DotUtils.firstMatch(input, DotUtils.SEGMENT);
            if (prop == null) {
                throw new ParseException(input, input.charAt(0), position);
            }
            NotedKey val = DotUtils.matches(prop, DotUtils.ACCESSOR) ? NotedKey.of(prop) : (DotUtils.matches(prop, DotUtils.INDEX) ? NotedKey.of(DotUtils.parseNum(DotUtils.firstMatch(prop, DotUtils.INDEX))) : NotedKey.of(DotUtils.firstMatch(prop, DotUtils.PROPERTY)));
            keys.add(val);
            int inputLen = input.length();
            int propLen = prop.length();
            if (inputLen == propLen) {
                remainder = "";
            } else {
                boolean isDot;
                remainder = input.substring(propLen);
                boolean bl = isDot = remainder.charAt(0) == '.';
                if (remainder.length() > 1) {
                    char nextChar = remainder.charAt(1);
                    if (!DotUtils.matches(nextChar, isDot ? DotUtils.ACCESSOR : DotUtils.OPENER)) {
                        throw new ParseException(input, nextChar, position + propLen + 1);
                    }
                } else {
                    throw new ParseException("Unable to parse key with trailing " + (isDot ? "dot" : "bracket") + "!");
                }
                if (isDot) {
                    remainder = remainder.substring(1);
                }
            }
            position += inputLen - remainder.length();
            input = remainder;
        }
        return keys;
    }

    public static void recurse(JsonNode node, NodeIterator handler) throws ParseException {
        DotNotes.recurse(node, handler, null);
    }

    public static void recurse(final JsonNode node, final NodeIterator handler, String start) throws ParseException {
        if (!node.isContainerNode()) {
            throw new IllegalArgumentException("Non-object provided to `recurse`!");
        }
        if (start == null) {
            start = "";
        }
        final String prefix = start;
        DotUtils.iterateNode(node, new DotUtils.KeyHandler(){

            @Override
            public void execute(NotedKey key) throws ParseException {
                JsonNode next;
                StringBuilder keystr = new StringBuilder(prefix);
                if (handler.requirePathGeneration()) {
                    String escaped = DotNotes.escape(key);
                    if (prefix.length() > 0 && escaped.charAt(0) != '[') {
                        keystr.append(".");
                    }
                    keystr.append(escaped);
                }
                if ((next = DotUtils.findNode(node, key)).isContainerNode()) {
                    DotNotes.recurse(next, handler, keystr.toString());
                    return;
                }
                handler.execute(key, next, keystr.toString());
            }
        });
    }

    public static abstract class NodeIterator {
        protected abstract void execute(NotedKey var1, JsonNode var2, String var3);

        protected boolean requirePathGeneration() {
            return true;
        }
    }
}

