/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.dotnotes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.zackehh.dotnotes.NotedKey;
import com.zackehh.dotnotes.ParseException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DotUtils {
    static final Pattern ACCESSOR = Pattern.compile("^[a-zA-Z_$][a-zA-Z0-9_$]*$");
    static final Pattern INDEX = Pattern.compile("^\\[([0-9]+)]$");
    static final Pattern OPENER = Pattern.compile("^(?:[0-9]|\"|')$");
    static final Pattern PROPERTY = Pattern.compile("^\\[(?:'|\")(.*)(?:'|\")]$");
    static final Pattern SEGMENT = Pattern.compile("^((?:[a-zA-Z_$][a-zA-Z0-9_$]*)|(?:\\[(?:'.*?(?='])'|\".*?(?=\"])\")])|(?:\\[\\d+]))");
    static final Pattern KEY = Pattern.compile(SEGMENT.toString() + "$");

    private DotUtils() {
        throw new UnsupportedOperationException();
    }

    static String firstMatch(String s, Pattern p) {
        Matcher m = p.matcher(s);
        return m.find() ? m.group(1) : null;
    }

    static boolean matches(char c, Pattern p) {
        return DotUtils.matches(String.valueOf(c), p);
    }

    static boolean matches(String s, Pattern p) {
        return p.matcher(s).find();
    }

    static Integer parseNum(String num) {
        return Integer.parseInt(num, 10);
    }

    static void set(JsonNode node, NotedKey key, JsonNode value) {
        if (key.isNumber()) {
            ArrayNode arr = (ArrayNode)node;
            int num = key.asNumber();
            if (num == node.size()) {
                arr.add(value);
            } else {
                arr.set(num, value);
            }
        } else {
            ((ObjectNode)node).set(key.asString(), value);
        }
    }

    static JsonNode findNode(JsonNode o, NotedKey k) {
        return k.isNumber() ? o.path(k.asNumber().intValue()) : o.path(k.asString());
    }

    static void iterateNode(JsonNode node, KeyHandler iterator) throws ParseException {
        if (node.isObject()) {
            Iterator names = node.fieldNames();
            while (names.hasNext()) {
                iterator.execute(NotedKey.of(names.next()));
            }
        } else {
            int j = node.size();
            for (int i = 0; i < j; ++i) {
                iterator.execute(NotedKey.of(i));
            }
        }
    }

    static interface KeyHandler {
        public void execute(NotedKey var1) throws ParseException;
    }
}

