/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.resolver;

import io.xspec.maven.xspecMavenPlugin.utils.QuietLogger;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlresolver.Catalog;
import org.xmlresolver.CatalogSource;

public class Resolver
implements URIResolver,
EntityResolver {
    private final URIResolver saxonResolver;
    private final Log log;
    org.xmlresolver.Resolver cr;
    private static final boolean LOG_ENABLE = false;

    public Resolver(URIResolver saxonResolver, File catalog, Log log) {
        this.saxonResolver = saxonResolver;
        this.log = log;
        this.cr = new org.xmlresolver.Resolver(new Catalog());
        this.cr.getCatalog().addSource((CatalogSource)new CatalogSource.UriCatalogSource(catalog.toURI().toString()));
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        this.getLog().debug((CharSequence)String.format("resolve(%s,%s)", href, base));
        this.getLog().debug((CharSequence)("catalogList=" + this.cr.getCatalog().catalogList()));
        this.getLog().debug((CharSequence)"Trying catalog");
        try {
            Source source = this.cr.resolve(href, base);
            this.getLog().debug((CharSequence)("source is " + (source == null ? "" : "not ") + "null"));
            if (source != null && source.getSystemId() != null) {
                this.getLog().debug((CharSequence)String.format("resolved from catalog to %s", source.getSystemId()));
                return source;
            }
            this.getLog().debug((CharSequence)"Trying saxon");
            source = this.saxonResolver.resolve(href, base);
            if (source != null && source.getSystemId() != null) {
                this.getLog().debug((CharSequence)String.format("resolved from saxon to %s", source.getSystemId()));
                return source;
            }
            this.getLog().error((CharSequence)String.format("fail to resolve (%s, %s)", href, base));
            return null;
        }
        catch (TransformerException ex) {
            this.getLog().error((CharSequence)("Resolver.resolve(" + href + "," + base + ")"), (Throwable)ex);
            throw ex;
        }
    }

    private Log getLog() {
        return QuietLogger.getLogger();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.cr.resolveEntity(publicId, systemId);
    }
}

