/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import io.xspec.maven.xspecMavenPlugin.resolver.Resolver;
import io.xspec.maven.xspecMavenPlugin.resources.SchematronImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.XSpecImplResources;
import io.xspec.maven.xspecMavenPlugin.resources.XSpecPluginResources;
import io.xspec.maven.xspecMavenPlugin.utils.CatalogWriter;
import io.xspec.maven.xspecMavenPlugin.utils.RunnerOptions;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecPluginException;
import io.xspec.maven.xspecMavenPlugin.utils.extenders.CatalogWriterExtender;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.plugin.logging.Log;
import top.marchand.maven.saxon.utils.SaxonOptions;
import top.marchand.maven.saxon.utils.SaxonUtils;

public class XmlStuff {
    private final Processor processor;
    private final DocumentBuilder documentBuilder;
    private final XsltCompiler xsltCompiler;
    private final XQueryCompiler xqueryCompiler;
    private final XPathCompiler xpathCompiler;
    private XsltExecutable xspec4xsltCompiler;
    private XsltExecutable xspec4xqueryCompiler;
    private XsltExecutable reporter;
    private XsltExecutable junitReporter;
    private XsltExecutable coverageReporter;
    private XsltExecutable xeSurefire;
    private XsltExecutable schDsdl;
    private XsltExecutable schExpand;
    private XsltExecutable schSvrl;
    private XsltExecutable xmlDependencyScanner;
    private XPathExecutable xpExecGetXSpecType;
    private XPathExecutable xpFileSearcher;
    public static final QName QN_REPORT_CSS = new QName("report-css-uri");
    public static final String RESOURCES_TEST_REPORT_CSS = "resources/test-report.css";
    private XPathExecutable xpSchGetXSpec;
    private XsltExecutable schSchut;
    private final Log log;
    private final XSpecImplResources xspecResources;
    private final XSpecPluginResources pluginResources;
    private final SchematronImplResources schematronResources;
    private final File baseDir;
    private final RunnerOptions options;
    private final Properties executionProperties;
    private String generateXspecUtilsUri;
    private String schLocationCompareUri;
    public static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final Class[] EMPTY_PARAMS = new Class[0];

    public XmlStuff(Processor processor, SaxonOptions saxonOptions, Log log, XSpecImplResources xspecResources, XSpecPluginResources pluginResources, SchematronImplResources schematronResources, File baseDir, RunnerOptions options, Properties executionProperties, CatalogWriterExtender extender) throws XSpecPluginException {
        this.processor = processor;
        this.xspecResources = xspecResources;
        this.pluginResources = pluginResources;
        this.schematronResources = schematronResources;
        this.baseDir = baseDir;
        this.options = options;
        this.executionProperties = executionProperties;
        this.log = log;
        if (saxonOptions != null) {
            try {
                SaxonUtils.prepareSaxonConfiguration((Processor)this.processor, (SaxonOptions)saxonOptions);
            }
            catch (XPathException ex) {
                this.getLog().error((Throwable)ex);
                throw new XSpecPluginException("Illegal value in Saxon configuration property", ex);
            }
        }
        this.documentBuilder = processor.newDocumentBuilder();
        try {
            this.xsltCompiler = processor.newXsltCompiler();
            this.xsltCompiler.setCompileWithTracing(true);
            this.xpathCompiler = processor.newXPathCompiler();
            this.xpathCompiler.declareNamespace("x", "http://www.jenitennison.com/xslt/xspec");
            this.xqueryCompiler = processor.newXQueryCompiler();
            this.xqueryCompiler.setCompileWithTracing(true);
            try {
                this.doAdditionalConfiguration(saxonOptions);
            }
            catch (XPathException ex) {
                throw new XSpecPluginException(ex);
            }
            try {
                this.xsltCompiler.setURIResolver(this.buildUriResolver(this.xsltCompiler.getURIResolver(), extender));
            }
            catch (IOException ex) {
                throw new XSpecPluginException("while constructing URIResolver", ex);
            }
            this.getLog().info((CharSequence)"URI resolver Ok");
            try {
                Enumeration<URL> enumer = this.getClass().getClassLoader().getResources("META-INF/services/top.marchand.xml.gaulois.xml");
                while (enumer.hasMoreElements()) {
                    String className;
                    Object it;
                    URL url = enumer.nextElement();
                    log.debug((CharSequence)("loading service " + url.toExternalForm()));
                    XdmNode document = this.documentBuilder.build((Source)new StreamSource(url.openStream()));
                    XPathSelector selector = this.xpathCompiler.compile("/gaulois-services/saxon/extensions/function").load();
                    selector.setContextItem((XdmItem)document);
                    Iterator o = selector.evaluate().iterator();
                    if (o instanceof XdmSequenceIterator) {
                        it = (XdmSequenceIterator)o;
                        while (it.hasNext()) {
                            className = it.next().getStringValue();
                            this.registerSaxonExtension(className);
                        }
                        continue;
                    }
                    it = o;
                    while (it.hasNext()) {
                        className = ((XdmItem)it.next()).getStringValue();
                        this.registerSaxonExtension(className);
                    }
                }
            }
            catch (IOException | SaxonApiException ex) {
                log.error((CharSequence)"while looking for resources in /META-INF/services/top.marchand.xml.gaulois/", ex);
            }
            try {
                this.createXPathExecutables();
                this.getLog().debug((CharSequence)"XPath executables created");
                this.createXsltExecutables();
                this.getLog().debug((CharSequence)"XSLT executables created");
            }
            catch (XSpecPluginException | IOException | URISyntaxException | SaxonApiException ex) {
                throw new XSpecPluginException(ex);
            }
        }
        catch (RuntimeException ex) {
            throw new XSpecPluginException(ex.getMessage(), ex);
        }
    }

    private void registerSaxonExtension(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (this.extendsClass(clazz, ExtensionFunctionDefinition.class)) {
                Class<?> cle = clazz;
                Constructor<?> cc = cle.getConstructor(EMPTY_PARAMS);
                this.processor.getUnderlyingConfiguration().registerExtensionFunction((ExtensionFunctionDefinition)cc.newInstance(new Object[0]));
                this.log.debug((CharSequence)(className + "registered as Saxon extension function"));
            } else {
                this.log.warn((CharSequence)(className + " does not extends " + ExtensionFunctionDefinition.class.getName()));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            this.log.warn((CharSequence)("unable to load extension function " + className));
        }
    }

    private URIResolver buildUriResolver(URIResolver saxonUriResolver, CatalogWriterExtender extender) throws IOException, XSpecPluginException {
        this.getLog().debug((CharSequence)"buildUriResolver");
        CatalogWriter cw = new CatalogWriter(this.getClass().getClassLoader(), extender);
        this.getLog().debug((CharSequence)"CatalogWriter instanciated");
        File catalog = cw.writeCatalog(this.options.catalogFile, this.executionProperties, this.options.keepGeneratedCatalog);
        if (this.options.keepGeneratedCatalog.booleanValue()) {
            this.getLog().info((CharSequence)("keeping generated catalog: " + catalog.toURI().toURL().toExternalForm()));
        }
        return new Resolver(saxonUriResolver, catalog, this.getLog());
    }

    private void createXPathExecutables() throws SaxonApiException {
        this.setXpExecGetXSpecType(this.getXPathCompiler().compile("/*/@*"));
        this.setXpSchGetXSpecFile(this.getXPathCompiler().compile("iri-to-uri(concat(replace(document-uri(/), '(.*)/.*$', '$1'), '/', /*[local-name() = 'description']/@schematron))"));
        this.setXpFileSearcher(this.getXPathCompiler().compile("//file[@dependency-type!='x:description']"));
    }

    private void createXsltExecutables() throws XSpecPluginException, SaxonApiException, IOException, URISyntaxException {
        this.getLog().debug((CharSequence)("Using XSpec Xslt Compiler: " + this.xspecResources.getXSpecXslCompilerUri()));
        this.getLog().debug((CharSequence)("Using XSpec Xquery Compiler: " + this.xspecResources.getXSpecXQueryCompilerUri()));
        this.getLog().debug((CharSequence)("Using XSpec Reporter: " + this.xspecResources.getXSpecReporterUri(this.options.folding)));
        this.getLog().debug((CharSequence)("Using Coverage Reporter: " + this.xspecResources.getXSpecCoverageReporterUri()));
        this.getLog().debug((CharSequence)("Using Schematron Dsdl include: " + this.schematronResources.getSchIsoDsdlIncludeUri()));
        this.getLog().debug((CharSequence)("Using Schematron expander: " + this.schematronResources.getSchIsoAbstractExpandUri()));
        this.getLog().debug((CharSequence)("Using Schematrong Svrl: " + this.schematronResources.getSchIsoSvrlForXslt2Uri()));
        this.getLog().debug((CharSequence)("Using Schematron schut: " + this.xspecResources.getSchematronSchutConverterUri()));
        this.getLog().debug((CharSequence)("Using XML dependency scanner: " + this.pluginResources.getDependencyScannerUri()));
        String baseUri = this.baseDir != null ? this.baseDir.toURI().toURL().toExternalForm() : null;
        Source srcXsltCompiler = this.resolveSrc(this.xspecResources.getXSpecXslCompilerUri(), baseUri, "XSpec XSL Compiler");
        this.getLog().debug((CharSequence)(this.xspecResources.getXSpecXslCompilerUri() + " -> " + srcXsltCompiler.getSystemId()));
        Source srcXqueryCompiler = this.resolveSrc(this.xspecResources.getXSpecXQueryCompilerUri(), baseUri, "XSpec XQuery Compiler");
        this.getLog().debug((CharSequence)(this.xspecResources.getXSpecXQueryCompilerUri() + " -> " + srcXqueryCompiler.getSystemId()));
        Source srcReporter = this.resolveSrc(this.xspecResources.getXSpecReporterUri(this.options.folding), baseUri, "XSpec Reporter");
        this.getLog().debug((CharSequence)(this.xspecResources.getXSpecReporterUri(this.options.folding) + " -> " + srcReporter.getSystemId()));
        Source srcCoverageReporter = this.resolveSrc(this.xspecResources.getXSpecCoverageReporterUri(), baseUri, "Coverage Reporter");
        this.getLog().debug((CharSequence)(this.xspecResources.getXSpecCoverageReporterUri() + " -> " + srcCoverageReporter.getSystemId()));
        Source srcSchIsoDsdl = this.resolveSrc(this.schematronResources.getSchIsoDsdlIncludeUri(), baseUri, "Schematron Dsdl");
        this.getLog().debug((CharSequence)(this.schematronResources.getSchIsoDsdlIncludeUri() + " -> " + srcSchIsoDsdl.getSystemId()));
        Source srcSchExpand = this.resolveSrc(this.schematronResources.getSchIsoAbstractExpandUri(), baseUri, "Schematron expander");
        this.getLog().debug((CharSequence)(this.schematronResources.getSchIsoAbstractExpandUri() + " -> " + srcSchExpand.getSystemId()));
        Source srcSchSvrl = this.resolveSrc(this.schematronResources.getSchIsoSvrlForXslt2Uri(), baseUri, "Schematron Svrl");
        this.getLog().debug((CharSequence)(this.schematronResources.getSchIsoSvrlForXslt2Uri() + " -> " + srcSchSvrl.getSystemId()));
        Source srcSchSchut = this.resolveSrc(this.xspecResources.getSchematronSchutConverterUri(), baseUri, "Schematron Schut");
        this.getLog().debug((CharSequence)(this.xspecResources.getSchematronSchutConverterUri() + " -> " + srcSchSchut.getSystemId()));
        Source srcXmlDependencyScanner = this.resolveSrc(this.pluginResources.getDependencyScannerUri(), baseUri, "Xml dependency scanner");
        this.getLog().debug((CharSequence)(this.pluginResources.getDependencyScannerUri() + " -> " + srcXmlDependencyScanner.getSystemId()));
        this.generateXspecUtilsUri = this.resolveSrc("generate-tests-utils.xsl", srcXsltCompiler.getSystemId(), "generate-tests-utils.xsl").getSystemId();
        this.schLocationCompareUri = this.resolveSrc("../schematron/sch-location-compare.xsl", srcXsltCompiler.getSystemId(), "../schematron/sch-location-compare.xsl").getSystemId();
        this.setXspec4xsltCompiler(this.compileXsl(srcXsltCompiler));
        this.setXspec4xqueryCompiler(this.compileXsl(srcXqueryCompiler));
        this.setReporter(this.compileReporter(srcReporter));
        if (this.isSaxonPEorEE()) {
            this.setCoverageReporter(this.compileXsl(srcCoverageReporter));
        }
        this.setSchematronDsdl(this.compileXsl(srcSchIsoDsdl));
        this.setSchematronExpand(this.compileXsl(srcSchExpand));
        this.setSchematronSvrl(this.compileXsl(srcSchSvrl));
        this.setSchematronSchut(this.compileXsl(srcSchSchut));
        this.setXmlDependencyScanner(this.compileXsl(srcXmlDependencyScanner));
        this.setXeSurefire(this.compileXsl(new StreamSource(this.getClass().getResourceAsStream("/surefire-reporter.xsl"))));
    }

    public boolean isSaxonPEorEE() {
        String configurationClassName = this.processor.getUnderlyingConfiguration().getClass().getName();
        return "com.saxonica.config.ProfessionalConfiguration".equals(configurationClassName) || "com.saxonica.config.EnterpriseConfiguration".equals(configurationClassName);
    }

    private XsltExecutable compileReporter(Source reporterSource) throws SaxonApiException, XSpecPluginException, IOException, URISyntaxException {
        if (reporterSource.getSystemId().contains("fold")) {
            this.getLog().debug((CharSequence)"reporter is folding");
            XdmNode xslSource = this.documentBuilder.build(reporterSource);
            XsltExecutable xslChanger = this.getXsltCompiler().compile(this.resolveSrc(this.pluginResources.getXsltImageChanger(), null, null));
            XsltTransformer tr = xslChanger.load();
            tr.setParameter(new QName("imgDown"), XdmValue.makeValue((Object)this.encodeBase64(this.pluginResources.getImageDown())));
            tr.setParameter(new QName("imgUp"), XdmValue.makeValue((Object)this.encodeBase64(this.pluginResources.getImageUp())));
            XdmDestination dest = new XdmDestination();
            tr.setDestination((Destination)dest);
            tr.setInitialContextNode(xslSource);
            tr.setBaseOutputURI(reporterSource.getSystemId());
            tr.transform();
            NodeInfo transformed = dest.getXdmNode().getUnderlyingNode();
            return this.getXsltCompiler().compile((Source)transformed);
        }
        this.getLog().debug((CharSequence)"reporter is not folding");
        return this.compileXsl(reporterSource);
    }

    private String encodeBase64(String uri) throws XSpecPluginException, IOException, URISyntaxException {
        Source source = this.resolveSrc(uri, null, null);
        URL resolvedUri = new URL(source.getSystemId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        InputStream is = resolvedUri.openStream();
        int read = is.read(buffer);
        long written = 0L;
        while (read > 0) {
            baos.write(buffer, 0, read);
            read = is.read(buffer);
            written += (long)read;
        }
        baos.flush();
        this.getLog().debug((CharSequence)("image is " + written + " bytes long"));
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(baos.toByteArray());
    }

    private Log getLog() {
        return this.log;
    }

    public XsltExecutable compileXsl(Source source) throws SaxonApiException {
        return this.getXsltCompiler().compile(source);
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public XsltCompiler getXsltCompiler() {
        return this.xsltCompiler;
    }

    public XPathCompiler getXPathCompiler() {
        return this.xpathCompiler;
    }

    public XsltExecutable getXspec4xsltCompiler() {
        return this.xspec4xsltCompiler;
    }

    private void setXspec4xsltCompiler(XsltExecutable xspec4xsltCompiler) {
        this.xspec4xsltCompiler = xspec4xsltCompiler;
    }

    public XsltExecutable getXspec4xqueryCompiler() {
        return this.xspec4xqueryCompiler;
    }

    private void setXspec4xqueryCompiler(XsltExecutable xspec4xqueryCompiler) {
        this.xspec4xqueryCompiler = xspec4xqueryCompiler;
    }

    public XsltExecutable getReporter() {
        return this.reporter;
    }

    private void setReporter(XsltExecutable reporter) {
        this.reporter = reporter;
    }

    public XsltTransformer getXtReporter() {
        XsltTransformer ret = this.getReporter().load();
        ret.setParameter(QN_REPORT_CSS, (XdmValue)new XdmAtomicValue(RESOURCES_TEST_REPORT_CSS));
        return ret;
    }

    public XPathExecutable getXpExecGetXSpecType() {
        return this.xpExecGetXSpecType;
    }

    private void setXpExecGetXSpecType(XPathExecutable xpExecGetXSpecType) {
        this.xpExecGetXSpecType = xpExecGetXSpecType;
    }

    public URIResolver getUriResolver() {
        return this.xsltCompiler.getURIResolver();
    }

    public XsltExecutable getXeSurefire() {
        return this.xeSurefire;
    }

    private void setXeSurefire(XsltExecutable xeSurefire) {
        this.xeSurefire = xeSurefire;
    }

    public Serializer newSerializer(OutputStream os) {
        return this.getProcessor().newSerializer(os);
    }

    public Serializer newSerializer() {
        return this.getProcessor().newSerializer();
    }

    public XQueryCompiler getXqueryCompiler() {
        return this.xqueryCompiler;
    }

    private void doAdditionalConfiguration(SaxonOptions saxonOptions) throws XPathException {
        if (saxonOptions != null) {
            SaxonUtils.configureXsltCompiler((XsltCompiler)this.getXsltCompiler(), (SaxonOptions)saxonOptions);
        }
    }

    private Source resolveSrc(String source, String baseUri, String desc) throws XSpecPluginException {
        try {
            Source ret = this.getUriResolver().resolve(source, baseUri);
            if (ret == null) {
                throw new XSpecPluginException("Could not find " + desc + " stylesheet in: " + source);
            }
            return ret;
        }
        catch (TransformerException ex) {
            throw new XSpecPluginException("while resolving " + source, ex);
        }
    }

    private void setSchematronDsdl(XsltExecutable xe) {
        this.schDsdl = xe;
    }

    private void setSchematronExpand(XsltExecutable xe) {
        this.schExpand = xe;
    }

    private void setSchematronSvrl(XsltExecutable xe) {
        this.schSvrl = xe;
    }

    public XsltExecutable getSchematronDsdl() {
        return this.schDsdl;
    }

    public XsltExecutable getSchematronExpand() {
        return this.schExpand;
    }

    public XsltExecutable getSchematronSvrl() {
        return this.schSvrl;
    }

    private void setXpSchGetXSpecFile(XPathExecutable xe) {
        this.xpSchGetXSpec = xe;
    }

    public XPathExecutable getXpSchGetXSpecFile() {
        return this.xpSchGetXSpec;
    }

    private void setSchematronSchut(XsltExecutable xe) {
        this.schSchut = xe;
    }

    public XsltExecutable getSchematronSchut() {
        return this.schSchut;
    }

    public XsltExecutable getXmlDependencyScanner() {
        return this.xmlDependencyScanner;
    }

    private void setXmlDependencyScanner(XsltExecutable xmlDependencyScanner) {
        this.xmlDependencyScanner = xmlDependencyScanner;
    }

    public XPathExecutable getXpFileSearcher() {
        return this.xpFileSearcher;
    }

    private void setXpFileSearcher(XPathExecutable xpFileSearcher) {
        this.xpFileSearcher = xpFileSearcher;
    }

    private boolean extendsClass(Class toCheck, Class inheritor) {
        if (toCheck.equals(inheritor)) {
            return true;
        }
        if (toCheck.equals(Object.class)) {
            return false;
        }
        return this.extendsClass(toCheck.getSuperclass(), inheritor);
    }

    public XsltExecutable getJUnitReporter() {
        return this.junitReporter;
    }

    private void setCoverageReporter(XsltExecutable xe) {
        this.coverageReporter = xe;
    }

    public XsltExecutable getCoverageReporter() {
        return this.coverageReporter;
    }
}

