/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import javax.annotation.Nullable;

public class HttpParser {
    public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer) {
        customizer.name(this.spanName(adapter, req));
        String path = adapter.path(req);
        if (path != null) {
            customizer.tag("http.path", path);
        }
    }

    protected <Req> String spanName(HttpAdapter<Req, ?> adapter, Req req) {
        return adapter.method(req);
    }

    public <Resp> void response(HttpAdapter<?, Resp> adapter, @Nullable Resp res, @Nullable Throwable error, SpanCustomizer customizer) {
        Integer httpStatus;
        Integer n = httpStatus = res != null ? adapter.statusCode(res) : null;
        if (httpStatus != null && (httpStatus < 200 || httpStatus > 299)) {
            customizer.tag("http.status_code", String.valueOf(httpStatus));
        }
        this.error(httpStatus, error, customizer);
    }

    protected void error(@Nullable Integer httpStatus, @Nullable Throwable error, SpanCustomizer customizer) {
        String message = null;
        if (error != null) {
            message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
        } else if (httpStatus != null) {
            String string = message = httpStatus < 200 || httpStatus > 399 ? String.valueOf(httpStatus) : null;
        }
        if (message != null) {
            customizer.tag("error", message);
        }
    }

    HttpParser() {
    }
}

