/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.http.HttpSampler;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import javax.annotation.Nullable;
import zipkin.Endpoint;

public final class HttpServerHandler<Req, Resp> {
    final Tracer tracer;
    final HttpSampler sampler;
    final HttpServerParser parser;
    final HttpServerAdapter<Req, Resp> adapter;

    public static <Req, Resp> HttpServerHandler create(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        return new HttpServerHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpServerHandler(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.serverSampler();
        this.parser = httpTracing.serverParser();
        this.adapter = adapter;
    }

    public Span handleReceive(TraceContext.Extractor<Req> extractor, Req request) {
        return this.handleReceive(extractor, request, request);
    }

    public <C> Span handleReceive(TraceContext.Extractor<C> extractor, C carrier, Req request) {
        Span span = this.nextSpan(extractor.extract(carrier), request);
        if (span.isNoop()) {
            return span;
        }
        span.kind(Span.Kind.SERVER).name(this.parser.spanName(this.adapter, request));
        this.parser.request(this.adapter, request, (SpanCustomizer)span);
        Endpoint.Builder remoteEndpoint = Endpoint.builder();
        if (this.adapter.parseClientAddress(request, remoteEndpoint)) {
            span.remoteEndpoint(remoteEndpoint.serviceName("").build());
        }
        return span.start();
    }

    Span nextSpan(TraceContextOrSamplingFlags contextOrFlags, Req request) {
        TraceContext extracted = contextOrFlags.context();
        if (extracted != null) {
            if (extracted.sampled() != null) {
                return this.tracer.joinSpan(contextOrFlags.context());
            }
            return this.tracer.joinSpan(extracted.toBuilder().sampled(this.sampler.trySample(this.adapter, request)).build());
        }
        SamplingFlags flags = contextOrFlags.samplingFlags();
        if (flags.sampled() == null) {
            flags = new SamplingFlags.Builder().sampled(this.sampler.trySample(this.adapter, request)).debug(flags.debug()).build();
        }
        return this.tracer.newTrace(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSend(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (span.isNoop()) {
            return;
        }
        try {
            this.parser.response(this.adapter, response, error, (SpanCustomizer)span);
        }
        finally {
            span.finish();
        }
    }
}

