/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Tracing;
import brave.http.AutoValue_HttpTracing;
import brave.http.HttpClientParser;
import brave.http.HttpSampler;
import brave.http.HttpServerParser;

public abstract class HttpTracing {
    public static HttpTracing create(Tracing tracing) {
        return HttpTracing.newBuilder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new AutoValue_HttpTracing.Builder().tracing(tracing).serverName("").clientParser(new HttpClientParser()).serverParser(new HttpServerParser()).clientSampler(HttpSampler.TRACE_ID).serverSampler(HttpSampler.TRACE_ID);
    }

    public abstract Tracing tracing();

    public abstract HttpClientParser clientParser();

    public abstract String serverName();

    public HttpTracing clientOf(String serverName) {
        return this.toBuilder().serverName(serverName).build();
    }

    public abstract HttpServerParser serverParser();

    public abstract HttpSampler clientSampler();

    public abstract HttpSampler serverSampler();

    public abstract Builder toBuilder();

    HttpTracing() {
    }

    public static abstract class Builder {
        public abstract Builder tracing(Tracing var1);

        public abstract Builder clientParser(HttpClientParser var1);

        public abstract Builder serverParser(HttpServerParser var1);

        public abstract Builder clientSampler(HttpSampler var1);

        public abstract Builder serverSampler(HttpSampler var1);

        public abstract HttpTracing build();

        abstract Builder serverName(String var1);

        Builder() {
        }
    }
}

