/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient;

import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.httpclient.TracingHttpClientBuilder$$Lambda$1;
import brave.httpclient.TracingHttpClientBuilder$$Lambda$4;
import brave.propagation.TraceContext;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;
import zipkin.Endpoint;

public final class TracingHttpClientBuilder
extends HttpClientBuilder {
    final Tracer tracer;
    final TraceContext.Injector<HttpRequestWrapper> injector;
    final HttpClientHandler<HttpRequestWrapper, HttpResponse> handler;

    public static HttpClientBuilder create(Tracing tracing) {
        return new TracingHttpClientBuilder(HttpTracing.create((Tracing)tracing));
    }

    public static HttpClientBuilder create(HttpTracing httpTracing) {
        return new TracingHttpClientBuilder(httpTracing);
    }

    TracingHttpClientBuilder(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(TracingHttpClientBuilder$$Lambda$1.lambdaFactory$());
    }

    protected ClientExecChain decorateMainExec(ClientExecChain exec) {
        return TracingHttpClientBuilder$$Lambda$4.lambdaFactory$(this, exec);
    }

    /*
     * Exception decompiling
     */
    static /* synthetic */ CloseableHttpResponse lambda$decorateMainExec$0(TracingHttpClientBuilder this, ClientExecChain exec, HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static final class HttpAdapter
    extends HttpClientAdapter<HttpRequestWrapper, HttpResponse> {
        HttpAdapter() {
        }

        public boolean parseServerAddress(HttpRequestWrapper httpRequest, Endpoint.Builder builder) {
            HttpHost target = httpRequest.getTarget();
            if (target == null) {
                return false;
            }
            if (builder.parseIp(target.getAddress()) || builder.parseIp(target.getHostName())) {
                builder.port(target.getPort());
                return true;
            }
            return false;
        }

        public String method(HttpRequestWrapper request) {
            return request.getRequestLine().getMethod();
        }

        public String path(HttpRequestWrapper request) {
            String result = request.getRequestLine().getUri();
            int queryIndex = result.indexOf(63);
            return queryIndex == -1 ? result : result.substring(0, queryIndex);
        }

        public String url(HttpRequestWrapper request) {
            HttpHost target = request.getTarget();
            if (target != null) {
                return target.toURI() + request.getURI();
            }
            return request.getRequestLine().getUri();
        }

        public String requestHeader(HttpRequestWrapper request, String name) {
            Header result = request.getFirstHeader(name);
            return result != null ? result.getValue() : null;
        }

        public Integer statusCode(HttpResponse response) {
            return response.getStatusLine().getStatusCode();
        }
    }
}

