/*
 * Decompiled with CFR 0.152.
 */
package brave.okhttp3;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.okhttp3.TraceContextCall;
import brave.okhttp3.TracingInterceptor;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public final class TracingCallFactory
implements Call.Factory {
    final CurrentTraceContext currentTraceContext;
    final OkHttpClient ok;

    public static Call.Factory create(Tracing tracing, OkHttpClient ok) {
        return TracingCallFactory.create(HttpTracing.create((Tracing)tracing), ok);
    }

    public static Call.Factory create(HttpTracing httpTracing, OkHttpClient ok) {
        return new TracingCallFactory(httpTracing, ok);
    }

    TracingCallFactory(HttpTracing httpTracing, OkHttpClient ok) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        if (ok == null) {
            throw new NullPointerException("OkHttpClient == null");
        }
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        OkHttpClient.Builder builder = ok.newBuilder();
        builder.networkInterceptors().add(0, TracingInterceptor.create(httpTracing));
        this.ok = builder.build();
    }

    public Call newCall(Request request) {
        TraceContext invocationContext = this.currentTraceContext.get();
        if (invocationContext != null) {
            OkHttpClient.Builder b = this.ok.newBuilder();
            b.interceptors().add(0, new TraceContextInterceptor(invocationContext));
            Call call = b.build().newCall(request);
            return new TraceContextCall(call, this.currentTraceContext, invocationContext);
        }
        return this.ok.newCall(request);
    }

    class TraceContextInterceptor
    implements Interceptor {
        final TraceContext invocationContext;

        TraceContextInterceptor(TraceContext invocationContext) {
            this.invocationContext = invocationContext;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            try (CurrentTraceContext.Scope ws = TracingCallFactory.this.currentTraceContext.maybeScope(this.invocationContext);){
                Response response = chain.proceed(chain.request());
                return response;
            }
        }
    }
}

