/*
 * Decompiled with CFR 0.152.
 */
package brave.okhttp3;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class TracingInterceptor
implements Interceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler;

    public static Interceptor create(Tracing tracing) {
        return TracingInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static Interceptor create(HttpTracing httpTracing) {
        return new TracingInterceptor(httpTracing);
    }

    TracingInterceptor(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    /*
     * Loose catch block
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        CurrentTraceContext.Scope ws;
        Throwable error;
        HttpClientResponse response2;
        Span span;
        block10: {
            HttpClientRequest request = new HttpClientRequest(chain.request());
            span = this.handler.handleSend((brave.http.HttpClientRequest)request);
            TracingInterceptor.parseRouteAddress(chain, span);
            response2 = null;
            error = null;
            ws = this.currentTraceContext.newScope(span.context());
            Response result = chain.proceed(request.build());
            response2 = new HttpClientResponse(result);
            response = result;
            if (ws == null) break block10;
            ws.close();
        }
        this.handler.handleReceive((Object)response2, error, span);
        return response;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | Error | RuntimeException e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    this.handler.handleReceive(response2, error, span);
                    throw throwable3;
                }
            }
        }
    }

    static void parseRouteAddress(Interceptor.Chain chain, Span span) {
        if (span.isNoop()) {
            return;
        }
        Connection connection = chain.connection();
        if (connection == null) {
            return;
        }
        InetSocketAddress socketAddress = connection.route().socketAddress();
        span.remoteIpAndPort(socketAddress.getHostString(), socketAddress.getPort());
    }

    static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        final Request delegate;
        Request.Builder builder;

        HttpClientRequest(Request delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method();
        }

        public String path() {
            return this.delegate.url().encodedPath();
        }

        public String url() {
            return this.delegate.url().toString();
        }

        public String header(String name) {
            return this.delegate.header(name);
        }

        public void header(String name, String value) {
            if (this.builder == null) {
                this.builder = this.delegate.newBuilder();
            }
            this.builder.header(name, value);
        }

        Request build() {
            return this.builder != null ? this.builder.build() : this.delegate;
        }
    }

    static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        final Response delegate;

        HttpClientResponse(Response delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return this.delegate.code();
        }
    }
}

