/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter.urlconnection;

import java.net.URL;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Encoding;
import zipkin.reporter.urlconnection.URLConnectionSender;

final class AutoValue_URLConnectionSender
extends URLConnectionSender {
    private final Encoding encoding;
    private final int messageMaxBytes;
    private final BytesMessageEncoder encoder;
    private final URL endpoint;
    private final int connectTimeout;
    private final int readTimeout;
    private final boolean compressionEnabled;
    private final String mediaType;

    private AutoValue_URLConnectionSender(Encoding encoding, int messageMaxBytes, BytesMessageEncoder encoder, URL endpoint, int connectTimeout, int readTimeout, boolean compressionEnabled, String mediaType) {
        this.encoding = encoding;
        this.messageMaxBytes = messageMaxBytes;
        this.encoder = encoder;
        this.endpoint = endpoint;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.compressionEnabled = compressionEnabled;
        this.mediaType = mediaType;
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    @Override
    BytesMessageEncoder encoder() {
        return this.encoder;
    }

    @Override
    URL endpoint() {
        return this.endpoint;
    }

    @Override
    int connectTimeout() {
        return this.connectTimeout;
    }

    @Override
    int readTimeout() {
        return this.readTimeout;
    }

    @Override
    boolean compressionEnabled() {
        return this.compressionEnabled;
    }

    @Override
    String mediaType() {
        return this.mediaType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof URLConnectionSender) {
            URLConnectionSender that = (URLConnectionSender)o;
            return this.encoding.equals((Object)that.encoding()) && this.messageMaxBytes == that.messageMaxBytes() && this.encoder.equals((Object)that.encoder()) && this.endpoint.equals(that.endpoint()) && this.connectTimeout == that.connectTimeout() && this.readTimeout == that.readTimeout() && this.compressionEnabled == that.compressionEnabled() && this.mediaType.equals(that.mediaType());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.encoding.hashCode();
        h *= 1000003;
        h ^= this.messageMaxBytes;
        h *= 1000003;
        h ^= this.encoder.hashCode();
        h *= 1000003;
        h ^= this.endpoint.hashCode();
        h *= 1000003;
        h ^= this.connectTimeout;
        h *= 1000003;
        h ^= this.readTimeout;
        h *= 1000003;
        h ^= this.compressionEnabled ? 1231 : 1237;
        h *= 1000003;
        return h ^= this.mediaType.hashCode();
    }

    @Override
    public URLConnectionSender.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends URLConnectionSender.Builder {
        private Encoding encoding;
        private Integer messageMaxBytes;
        private BytesMessageEncoder encoder;
        private URL endpoint;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Boolean compressionEnabled;
        private String mediaType;

        Builder() {
        }

        private Builder(URLConnectionSender source) {
            this.encoding = source.encoding();
            this.messageMaxBytes = source.messageMaxBytes();
            this.encoder = source.encoder();
            this.endpoint = source.endpoint();
            this.connectTimeout = source.connectTimeout();
            this.readTimeout = source.readTimeout();
            this.compressionEnabled = source.compressionEnabled();
            this.mediaType = source.mediaType();
        }

        @Override
        public URLConnectionSender.Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("Null encoding");
            }
            this.encoding = encoding;
            return this;
        }

        @Override
        Encoding encoding() {
            if (this.encoding == null) {
                throw new IllegalStateException("Property \"encoding\" has not been set");
            }
            return this.encoding;
        }

        @Override
        public URLConnectionSender.Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        @Override
        URLConnectionSender.Builder encoder(BytesMessageEncoder encoder) {
            if (encoder == null) {
                throw new NullPointerException("Null encoder");
            }
            this.encoder = encoder;
            return this;
        }

        @Override
        public URLConnectionSender.Builder endpoint(URL endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("Null endpoint");
            }
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public URLConnectionSender.Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        public URLConnectionSender.Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public URLConnectionSender.Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        @Override
        URLConnectionSender.Builder mediaType(String mediaType) {
            if (mediaType == null) {
                throw new NullPointerException("Null mediaType");
            }
            this.mediaType = mediaType;
            return this;
        }

        @Override
        URLConnectionSender autoBuild() {
            String missing = "";
            if (this.encoding == null) {
                missing = missing + " encoding";
            }
            if (this.messageMaxBytes == null) {
                missing = missing + " messageMaxBytes";
            }
            if (this.encoder == null) {
                missing = missing + " encoder";
            }
            if (this.endpoint == null) {
                missing = missing + " endpoint";
            }
            if (this.connectTimeout == null) {
                missing = missing + " connectTimeout";
            }
            if (this.readTimeout == null) {
                missing = missing + " readTimeout";
            }
            if (this.compressionEnabled == null) {
                missing = missing + " compressionEnabled";
            }
            if (this.mediaType == null) {
                missing = missing + " mediaType";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_URLConnectionSender(this.encoding, this.messageMaxBytes, this.encoder, this.endpoint, this.connectTimeout, this.readTimeout, this.compressionEnabled, this.mediaType);
        }
    }
}

