/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import zipkin2.reporter.ReporterMetrics;

public class MicrometerReporterMetrics
implements ReporterMetrics {
    private static final String PREFIX = "zipkin.reporter.";
    final MeterRegistry meterRegistry;
    final Iterable<Tag> extraTags;
    final Counter messages;
    final Counter messageBytes;
    final Counter spans;
    final Counter spanBytes;
    final Counter spansDropped;
    final AtomicInteger queuedSpans;
    final AtomicInteger queuedBytes;

    public static MicrometerReporterMetrics create(MeterRegistry meterRegistry) {
        return new Builder(meterRegistry).build();
    }

    public static Builder builder(MeterRegistry meterRegistry) {
        return new Builder(meterRegistry);
    }

    private MicrometerReporterMetrics(MeterRegistry meterRegistry, Tag ... extraTags) {
        this.meterRegistry = meterRegistry;
        this.extraTags = Arrays.asList(extraTags);
        this.messages = Counter.builder((String)"zipkin.reporter.messages.total").description("Messages reported (or attempted to be reported)").tags(this.extraTags).register(meterRegistry);
        this.messageBytes = Counter.builder((String)"zipkin.reporter.messages").description("Total bytes of messages reported").baseUnit("bytes").tags(this.extraTags).register(meterRegistry);
        this.spans = Counter.builder((String)"zipkin.reporter.spans.total").description("Spans reported").tags(this.extraTags).register(meterRegistry);
        this.spanBytes = Counter.builder((String)"zipkin.reporter.spans").description("Total bytes of encoded spans reported").baseUnit("bytes").tags(this.extraTags).register(meterRegistry);
        this.spansDropped = Counter.builder((String)"zipkin.reporter.spans.dropped").description("Spans dropped (failed to report)").tags(this.extraTags).register(meterRegistry);
        this.queuedSpans = new AtomicInteger();
        Gauge.builder((String)"zipkin.reporter.queue.spans", (Object)this.queuedSpans, AtomicInteger::get).description("Spans queued for reporting").tags(this.extraTags).register(meterRegistry);
        this.queuedBytes = new AtomicInteger();
        Gauge.builder((String)"zipkin.reporter.queue.bytes", (Object)this.queuedBytes, AtomicInteger::get).description("Total size of all encoded spans queued for reporting").baseUnit("bytes").tags(this.extraTags).register(meterRegistry);
    }

    public void incrementMessages() {
        this.messages.increment();
    }

    public void incrementMessageBytes(int i) {
        this.messageBytes.increment((double)i);
    }

    public void incrementMessagesDropped(Throwable cause) {
        Tags tags = Tags.concat(this.extraTags, (String[])new String[]{"cause", cause.getClass().getSimpleName()});
        this.meterRegistry.counter("zipkin.reporter.messages.dropped", (Iterable)tags).increment();
    }

    public void incrementSpans(int i) {
        this.spans.increment((double)i);
    }

    public void incrementSpanBytes(int i) {
        this.spanBytes.increment((double)i);
    }

    public void incrementSpansDropped(int i) {
        this.spansDropped.increment((double)i);
    }

    public void updateQueuedSpans(int i) {
        this.queuedSpans.set(i);
    }

    public void updateQueuedBytes(int i) {
        this.queuedBytes.set(i);
    }

    public static final class Builder {
        final MeterRegistry meterRegistry;
        Tag[] extraTags = new Tag[0];

        Builder(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
        }

        public Builder extraTags(Tag ... extraTags) {
            this.extraTags = extraTags;
            return this;
        }

        public MicrometerReporterMetrics build() {
            return new MicrometerReporterMetrics(this.meterRegistry, this.extraTags);
        }
    }
}

