/* Copyright 2010,2014 Bank Of Italy
*
* Licensed under the EUPL, Version 1.1 or - as soon they
* will be approved by the European Commission - subsequent
* versions of the EUPL (the "Licence");
* You may not use this work except in compliance with the
* Licence.
* You may obtain a copy of the Licence at:
*
*
* http://ec.europa.eu/idabc/eupl
*
* Unless required by applicable law or agreed to in
* writing, software distributed under the Licence is
* distributed on an "AS IS" basis,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied.
* See the Licence for the specific language governing
* permissions and limitations under the Licence.
*/
package it.bancaditalia.oss.sdmx.helper;

import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

import javax.swing.JTextArea;

public class HelperHandler extends java.util.logging.Handler {
	private SimpleFormatter formatter = new SimpleFormatter();

    public HelperHandler(JTextArea whereTo) {
		super();
		this.whereTo = whereTo;
	}

	private JTextArea whereTo = null;

    @Override
    public void publish(final LogRecord record) {
    	whereTo.append(formatter.format(record));
    	whereTo.setCaretPosition(whereTo.getDocument().getLength());
    }

	@Override
	public void flush() {
	}

	@Override
	public void close() throws SecurityException {
	}
}