/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves;

import hudson.Launcher;
import hudson.Proc;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.slaves.SlaveComputer;
import it.dockins.dockerslaves.Container;
import it.dockins.dockerslaves.ContainersContext;
import it.dockins.dockerslaves.spec.ContainerDefinition;
import it.dockins.dockerslaves.spec.ContainerSetDefinition;
import it.dockins.dockerslaves.spec.SideContainerDefinition;
import it.dockins.dockerslaves.spi.DockerDriver;
import it.dockins.dockerslaves.spi.DockerProvisioner;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class DefaultDockerProvisioner
extends DockerProvisioner {
    protected final ContainersContext context;
    protected final DockerDriver driver;
    protected final ContainerSetDefinition spec;
    protected final String remotingImage;
    protected final String scmImage;

    public DefaultDockerProvisioner(ContainersContext context, DockerDriver driver, Job job, ContainerSetDefinition spec, String remotingImage, String scmImage) throws IOException, InterruptedException {
        this.context = context;
        this.driver = driver;
        this.spec = spec;
        this.remotingImage = remotingImage;
        this.scmImage = scmImage;
    }

    @Override
    public ContainersContext getContext() {
        return this.context;
    }

    @Override
    public Container launchRemotingContainer(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        Container existing = this.context.getRemotingContainer();
        if (existing != null && this.driver.hasContainer(listener, existing.getId())) {
            return existing;
        }
        String volume = this.context.getWorkdirVolume();
        if (!this.driver.hasVolume(listener, volume)) {
            volume = this.driver.createVolume(listener);
            this.context.setWorkdirVolume(volume);
        }
        Container remotingContainer = this.driver.launchRemotingContainer(listener, this.remotingImage, volume, computer);
        this.context.setRemotingContainer(remotingContainer);
        return remotingContainer;
    }

    @Override
    public Container launchBuildContainers(Launcher.ProcStarter starter, TaskListener listener) throws IOException, InterruptedException {
        if (this.spec.getSideContainers().size() > 0 && this.context.getSideContainers().size() == 0) {
            this.createSideContainers(starter, listener);
        }
        ContainerDefinition build = this.spec.getBuildHostImage();
        String buildImage = build.getImage(this.driver, starter, listener);
        List<String> mounts = build.getMounts();
        Container buildContainer = this.driver.launchBuildContainer(listener, buildImage, this.context.getRemotingContainer(), mounts);
        this.context.setBuildContainer(buildContainer);
        return buildContainer;
    }

    @Override
    public Container launchScmContainer(TaskListener listener) throws IOException, InterruptedException {
        Container scmContainer = this.driver.launchBuildContainer(listener, this.scmImage, this.context.getRemotingContainer(), Collections.EMPTY_LIST);
        this.context.setBuildContainer(scmContainer);
        return scmContainer;
    }

    private void createSideContainers(Launcher.ProcStarter starter, TaskListener listener) throws IOException, InterruptedException {
        for (SideContainerDefinition definition : this.spec.getSideContainers()) {
            String name = definition.getName();
            ContainerDefinition sidecar = definition.getSpec();
            String image = sidecar.getImage(this.driver, starter, listener);
            List<String> mounts = sidecar.getMounts();
            listener.getLogger().println("Starting " + name + " container");
            Container container = this.driver.launchSideContainer(listener, image, this.context.getRemotingContainer(), mounts);
            this.context.getSideContainers().put(name, container);
        }
    }

    @Override
    public Proc launchBuildProcess(Launcher.ProcStarter procStarter, TaskListener listener) throws IOException, InterruptedException {
        Container targetContainer = null;
        if (this.context.isPreScm()) {
            targetContainer = this.context.getScmContainer();
            if (targetContainer == null) {
                targetContainer = this.launchScmContainer(listener);
            }
        } else {
            targetContainer = this.context.getBuildContainer();
            if (targetContainer == null) {
                targetContainer = this.launchBuildContainers(procStarter, listener);
            }
        }
        return this.driver.execInContainer(listener, targetContainer.getId(), procStarter);
    }

    @Override
    public void clean(TaskListener listener) throws IOException, InterruptedException {
        for (Container instance : this.context.getSideContainers().values()) {
            this.driver.removeContainer(listener, instance);
        }
        if (this.context.getBuildContainer() != null) {
            this.driver.removeContainer(listener, this.context.getBuildContainer());
        }
        if (this.context.getScmContainer() != null) {
            this.driver.removeContainer(listener, this.context.getScmContainer());
        }
        this.driver.close();
    }
}

