/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import it.dockins.dockerslaves.ContainersContext;
import it.dockins.dockerslaves.DefaultDockerProvisioner;
import it.dockins.dockerslaves.spec.ContainerSetDefinition;
import it.dockins.dockerslaves.spi.DockerDriver;
import it.dockins.dockerslaves.spi.DockerDriverFactory;
import it.dockins.dockerslaves.spi.DockerProvisioner;
import it.dockins.dockerslaves.spi.DockerProvisionerFactory;
import it.dockins.dockerslaves.spi.DockerProvisionerFactoryDescriptor;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DefaultDockerProvisionerFactory
extends DockerProvisionerFactory {
    private final DockerDriverFactory dockerDriverFactory;
    private String scmImage;
    private String remotingImage;

    @DataBoundConstructor
    public DefaultDockerProvisionerFactory(DockerDriverFactory dockerDriverFactory) {
        this.dockerDriverFactory = dockerDriverFactory;
    }

    public DockerDriverFactory getDockerDriverFactory() {
        return this.dockerDriverFactory;
    }

    public String getScmImage() {
        return StringUtils.isBlank((String)this.scmImage) ? "buildpack-deps:scm" : this.scmImage;
    }

    public String getRemotingImage() {
        return StringUtils.isBlank((String)this.remotingImage) ? "jenkinsci/slave" : this.remotingImage;
    }

    @DataBoundSetter
    public void setScmImage(String scmImage) {
        this.scmImage = scmImage;
    }

    @DataBoundSetter
    public void setRemotingImage(String remotingImage) {
        this.remotingImage = remotingImage;
    }

    protected void prepareWorkspace(Job job, ContainersContext context) {
        ContainersContext previousContext;
        Run lastBuild = job.getLastCompletedBuild();
        if (lastBuild != null && (previousContext = (ContainersContext)lastBuild.getAction(ContainersContext.class)) != null && previousContext.getWorkdirVolume() != null) {
            context.setWorkdirVolume(previousContext.getWorkdirVolume());
        }
    }

    @Override
    public DockerProvisioner createProvisionerForClassicJob(Job job, ContainerSetDefinition spec) throws IOException, InterruptedException {
        DockerDriver driver = this.dockerDriverFactory.forJob(job);
        ContainersContext context = new ContainersContext();
        this.prepareWorkspace(job, context);
        return new DefaultDockerProvisioner(context, driver, job, spec, this.getRemotingImage(), this.getScmImage());
    }

    @Override
    public DockerProvisioner createProvisionerForPipeline(Job job, ContainerSetDefinition spec) throws IOException, InterruptedException {
        DockerDriver driver = this.dockerDriverFactory.forJob(job);
        ContainersContext context = new ContainersContext(false);
        return new DefaultDockerProvisioner(context, driver, job, spec, this.getRemotingImage(), this.getScmImage());
    }

    @Extension
    public static class DescriptorImpl
    extends DockerProvisionerFactoryDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "Compose docker containers";
        }
    }
}

