/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves;

import hudson.EnvVars;
import hudson.slaves.ComputerLauncher;
import it.dockins.dockerslaves.DockerComputerLauncher;
import it.dockins.dockerslaves.DockerSlave;
import it.dockins.dockerslaves.api.OneShotComputer;
import it.dockins.dockerslaves.spi.DockerProvisioner;
import java.io.IOException;
import java.util.logging.Logger;

public class DockerComputer
extends OneShotComputer {
    private final DockerSlave slave;
    private final DockerProvisioner provisioner;
    private static final Logger LOGGER = Logger.getLogger(DockerComputer.class.getName());

    public DockerComputer(DockerSlave slave, DockerProvisioner provisioner) {
        super(slave);
        this.provisioner = provisioner;
        this.slave = slave;
    }

    @Override
    public DockerSlave getNode() {
        return this.slave;
    }

    public Boolean isUnix() {
        return Boolean.TRUE;
    }

    public EnvVars getEnvironment() throws IOException, InterruptedException {
        return new EnvVars();
    }

    @Override
    protected void terminate() {
        LOGGER.info("Stopping Docker Slave after build completion");
        this.setAcceptingTasks(false);
        try {
            this.provisioner.clean(this.getListener());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.terminate();
    }

    public DockerProvisioner getProvisioner() {
        return this.provisioner;
    }

    public ComputerLauncher createComputerLauncher() {
        return new DockerComputerLauncher();
    }
}

