/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import it.dockins.dockerslaves.ContainersContext;
import it.dockins.dockerslaves.DockerComputer;
import it.dockins.dockerslaves.DockerComputerLauncher;
import it.dockins.dockerslaves.DockerLauncher;
import it.dockins.dockerslaves.api.OneShotSlave;
import it.dockins.dockerslaves.spi.DockerProvisioner;
import java.io.IOException;

public class DockerSlave
extends OneShotSlave {
    public static final String SLAVE_ROOT = "/home/jenkins/.jenkins/";
    private final DockerProvisioner provisioner;
    private final long queueItemId;

    public DockerSlave(String name, String nodeDescription, String labelString, DockerProvisioner provisioner, Queue.Item queueItem) throws Descriptor.FormException, IOException {
        super(name.replaceAll("/", " \u00bb "), nodeDescription, SLAVE_ROOT, labelString, new DockerComputerLauncher());
        this.provisioner = provisioner;
        this.queueItemId = queueItem.getId();
    }

    public DockerComputer createComputer() {
        return new DockerComputer(this, this.provisioner);
    }

    public DockerSlave asNode() {
        return this;
    }

    @Override
    public DockerComputer getComputer() {
        return (DockerComputer)super.getComputer();
    }

    public long getQueueItemId() {
        return this.queueItemId;
    }

    @Override
    public Launcher createLauncher(TaskListener listener) {
        DockerComputer c = this.getComputer();
        if (c == null) {
            listener.error("Issue with creating launcher for slave " + this.name + ".");
            throw new IllegalStateException("Can't create a launcher if computer is gone.");
        }
        super.createLauncher(listener);
        Channel channel = c.getChannel();
        if (channel == null) {
            throw new IllegalStateException("Can't create a Launcher: channel not connected");
        }
        return new DockerLauncher(listener, (VirtualChannel)channel, c.isUnix(), this.provisioner).decorateFor((Node)this);
    }

    @Extension
    public static class DockerSlaveSCMListener
    extends SCMListener {
        public void onChangeLogParsed(Run<?, ?> build, SCM scm, TaskListener listener, ChangeLogSet<?> changelog) throws Exception {
            ContainersContext action = (ContainersContext)build.getAction(ContainersContext.class);
            if (action != null) {
                action.onScmChekoutCompleted(build, listener);
            }
        }
    }

    @Extension
    public static class DockerSlaveRunListener
    extends RunListener<Run> {
        public void onStarted(Run run, TaskListener listener) {
            Computer c = Computer.currentComputer();
            if (c instanceof DockerComputer) {
                run.addAction((Action)((DockerComputer)c).getProvisioner().getContext());
            }
        }
    }
}

