/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import it.dockins.dockerslaves.DefaultDockerProvisionerFactory;
import it.dockins.dockerslaves.drivers.PlainDockerAPIDockerDriverFactory;
import it.dockins.dockerslaves.spec.ContainerSetDefinition;
import it.dockins.dockerslaves.spi.DockerProvisioner;
import it.dockins.dockerslaves.spi.DockerProvisionerFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class DockerSlaves
extends Plugin
implements Describable<DockerSlaves> {
    private String defaultBuildContainerImageName;
    private DockerProvisionerFactory dockerProvisionerFactory;
    private int maxSlaves = 10;
    public String scmContainerImageName;
    public String remotingContainerImageName;
    public DockerServerEndpoint dockerHost;

    public void start() throws IOException {
        this.load();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
    }

    public String getDefaultBuildContainerImageName() {
        return this.defaultBuildContainerImageName;
    }

    @DataBoundSetter
    public void setDefaultBuildContainerImageName(String defaultBuildContainerImageName) {
        this.defaultBuildContainerImageName = defaultBuildContainerImageName;
    }

    @DataBoundSetter
    public void setDockerProvisionerFactory(DockerProvisionerFactory dockerProvisionerFactory) {
        this.dockerProvisionerFactory = dockerProvisionerFactory;
    }

    public DockerProvisionerFactory getDockerProvisionerFactory() {
        if (this.dockerProvisionerFactory == null) {
            DefaultDockerProvisionerFactory factory = new DefaultDockerProvisionerFactory(new PlainDockerAPIDockerDriverFactory(this.dockerHost));
            factory.setRemotingImage(this.remotingContainerImageName);
            factory.setScmImage(this.scmContainerImageName);
            this.dockerProvisionerFactory = factory;
            return this.dockerProvisionerFactory;
        }
        return this.dockerProvisionerFactory;
    }

    public DockerProvisioner createStandardJobProvisionerFactory(Job job) throws IOException, InterruptedException {
        ContainerSetDefinition spec = (ContainerSetDefinition)job.getProperty(ContainerSetDefinition.class);
        return this.getDockerProvisionerFactory().createProvisionerForClassicJob(job, spec);
    }

    public int getMaxSlaves() {
        return this.maxSlaves;
    }

    @DataBoundSetter
    public void setMaxSlaves(int maxSlaves) {
        this.maxSlaves = maxSlaves;
    }

    public DockerProvisioner createProvisionerForPipeline(Job job, ContainerSetDefinition spec) throws IOException, InterruptedException {
        return this.getDockerProvisionerFactory().createProvisionerForPipeline(job, spec);
    }

    public static DockerSlaves get() {
        return (DockerSlaves)Jenkins.getActiveInstance().getPlugin(DockerSlaves.class);
    }

    public Descriptor<DockerSlaves> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorOrDie(DockerSlaves.class);
    }

    static {
        Jenkins.XSTREAM.aliasPackage("xyz.quoidneufdocker.jenkins", "it.dockins");
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerSlaves> {
        public String getDisplayName() {
            return "Docker Slaves";
        }
    }
}

