/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import it.dockins.dockerslaves.DockerSlave;
import it.dockins.dockerslaves.DockerSlaveAssignmentAction;
import it.dockins.dockerslaves.DockerSlaves;
import it.dockins.dockerslaves.spec.ContainerSetDefinition;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class ProvisionQueueListener
extends QueueListener {
    private static final Logger LOGGER = Logger.getLogger(ProvisionQueueListener.class.getName());

    public void onEnterBuildable(Queue.BuildableItem item) {
        if (item.task instanceof AbstractProject) {
            AbstractProject job = (AbstractProject)item.task;
            ContainerSetDefinition def = (ContainerSetDefinition)job.getProperty(ContainerSetDefinition.class);
            if (def == null) {
                return;
            }
            try {
                final Node node = this.prepareExecutorFor(item, job);
                DockerSlaveAssignmentAction action = new DockerSlaveAssignmentAction(node.getNodeName());
                item.addAction((Action)action);
                Computer.threadPoolForRemoting.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Jenkins.getActiveInstance().addNode(node);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failure to create Docker Slave", e);
                Jenkins.getActiveInstance().getQueue().cancel((Queue.Item)item);
            }
        }
    }

    private Node prepareExecutorFor(Queue.BuildableItem item, AbstractProject job) throws Descriptor.FormException, IOException, InterruptedException {
        LOGGER.info("Creating a Container slave to host " + job.toString() + "#" + job.getNextBuildNumber());
        String slaveName = "Container for " + job.getName() + "#" + job.getNextBuildNumber();
        String description = "Container slave for building " + job.getFullName();
        DockerSlaves plugin = DockerSlaves.get();
        return new DockerSlave(slaveName, description, null, plugin.createStandardJobProvisionerFactory((Job)job), (Queue.Item)item);
    }

    public void onLeft(Queue.LeftItem item) {
        if (item.isCancelled()) {
            DockerSlaveAssignmentAction action = (DockerSlaveAssignmentAction)item.getAction(DockerSlaveAssignmentAction.class);
            if (action == null) {
                return;
            }
            DockerSlave slave = action.getAssignedNodeName();
            if (slave == null) {
                return;
            }
            try {
                Jenkins.getActiveInstance().removeNode((Node)slave);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failure to remove One-Shot Slave", e);
            }
        }
    }
}

