/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import it.dockins.dockerslaves.DockerSlave;
import it.dockins.dockerslaves.DockerSlaves;
import it.dockins.dockerslaves.spec.ContainerSetDefinition;
import jenkins.model.Jenkins;

@Extension
public class ProvisionScheduler
extends QueueTaskDispatcher {
    public CauseOfBlockage canRun(Queue.Item item) {
        if (item.task instanceof AbstractProject) {
            AbstractProject job = (AbstractProject)item.task;
            ContainerSetDefinition def = (ContainerSetDefinition)job.getProperty(ContainerSetDefinition.class);
            if (def == null) {
                return null;
            }
            int slaveCount = 0;
            DockerSlaves plugin = DockerSlaves.get();
            for (Node node : Jenkins.getActiveInstance().getNodes()) {
                if (!(node instanceof DockerSlave)) continue;
                if (((DockerSlave)node).getQueueItemId() == item.getId()) {
                    return null;
                }
                ++slaveCount;
            }
            if (slaveCount >= plugin.getMaxSlaves()) {
                return new WaitForADockerSlot();
            }
            return null;
        }
        return null;
    }

    static final class WaitForADockerSlot
    extends CauseOfBlockage {
        private WaitForADockerSlot() {
        }

        public String getShortDescription() {
            return "Waiting for a Docker slot";
        }
    }
}

