/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.api;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerListener;
import hudson.slaves.SlaveComputer;
import it.dockins.dockerslaves.api.OneShotSlave;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public abstract class OneShotComputer
extends SlaveComputer {
    private final OneShotSlave slave;
    private TaskListener listener;
    @Extension
    public static final ComputerListener COMPUTER_LISTENER = new ComputerListener(){

        public void preLaunch(Computer c, TaskListener listener) throws IOException, InterruptedException {
            if (c instanceof OneShotComputer) {
                ((OneShotComputer)c).setListener(listener);
            }
        }
    };

    public OneShotComputer(OneShotSlave slave) {
        super((Slave)slave);
        this.slave = slave;
    }

    public boolean isOffline() {
        OneShotSlave node = this.getNode();
        if (node != null) {
            if (node.hasProvisioningFailed()) {
                return true;
            }
            if (!node.hasExecutable()) {
                return false;
            }
        }
        return this.isActuallyOffline();
    }

    public boolean isActuallyOffline() {
        return super.isOffline();
    }

    @Nonnull
    public OneShotSlave getNode() {
        return this.slave;
    }

    protected boolean isAlive() {
        if (this.getNode().hasExecutable()) {
            this.terminate();
        }
        return super.isAlive();
    }

    protected void terminate() {
        try {
            Jenkins.getActiveInstance().removeNode((Node)this.slave);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Charset getDefaultCharset() {
        return StandardCharsets.UTF_8;
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public TaskListener getListener() {
        return this.listener;
    }
}

