/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.api;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import it.dockins.dockerslaves.api.OneShotComputer;
import it.dockins.dockerslaves.api.OneShotExecutorProvisioningException;
import java.io.IOException;
import java.util.Collections;
import jenkins.model.Jenkins;

public abstract class OneShotSlave
extends Slave
implements EphemeralNode {
    private transient Queue.Executable executable;
    private final ComputerLauncher realLauncher;
    private boolean provisioningFailed = false;
    @Extension(ordinal=1.7976931348623157E308)
    public static final RunListener RUN_LISTENER = new RunListener<Run>(){

        public void onStarted(Run run, TaskListener listener) {
            Computer c = Computer.currentComputer();
            if (c != null && c instanceof OneShotComputer) {
                OneShotSlave node = ((OneShotComputer)c).getNode();
                node.provision(listener);
            }
        }
    };
    private static final ComputerLauncher NOOP_LAUNCHER = new ComputerLauncher(){

        public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        }
    };

    public OneShotSlave(String name, String nodeDescription, String remoteFS, String labelString, ComputerLauncher launcher) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, 1, Node.Mode.EXCLUSIVE, labelString, NOOP_LAUNCHER, RetentionStrategy.NOOP, Collections.emptyList());
        this.realLauncher = launcher;
    }

    public int getNumExecutors() {
        return 1;
    }

    boolean hasExecutable() {
        return this.executable != null;
    }

    boolean hasProvisioningFailed() {
        return this.provisioningFailed;
    }

    public OneShotComputer getComputer() {
        return (OneShotComputer)super.getComputer();
    }

    synchronized void provision(TaskListener listener) {
        if (this.executable != null) {
            return;
        }
        Executor executor = Executor.currentExecutor();
        if (executor == null) {
            throw new IllegalStateException("running task without associated executor thread");
        }
        try {
            this.realLauncher.launch((SlaveComputer)this.getComputer(), listener);
            if (this.getComputer().isActuallyOffline()) {
                this.provisionFailed(new IllegalStateException("Computer is offline after launch"));
            }
        }
        catch (Exception e) {
            this.provisionFailed(e);
        }
        this.executable = executor.getCurrentExecutable();
    }

    void provisionFailed(Exception cause) {
        if (this.executable instanceof Run) {
            ((Run)this.executable).setResult(Result.NOT_BUILT);
        }
        try {
            Jenkins.getActiveInstance().removeNode((Node)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new OneShotExecutorProvisioningException(cause);
    }

    public Launcher createLauncher(TaskListener listener) {
        this.provision(listener);
        return super.createLauncher(listener);
    }
}

