/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.drivers;

import hudson.Launcher;
import hudson.Proc;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.org.apache.tools.tar.TarOutputStream;
import hudson.slaves.CommandLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.ArgumentListBuilder;
import hudson.util.VersionNumber;
import it.dockins.dockerslaves.Container;
import it.dockins.dockerslaves.ProvisionQueueListener;
import it.dockins.dockerslaves.spi.DockerDriver;
import it.dockins.dockerslaves.spi.DockerHostConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;

public class CliDockerDriver
extends DockerDriver {
    private static final boolean verbose = Boolean.getBoolean(DockerDriver.class.getName() + ".verbose");
    private final DockerHostConfig dockerHost;
    private final VersionNumber version;
    private static final Logger LOGGER = Logger.getLogger(ProvisionQueueListener.class.getName());
    VersionNumber SWARM = new VersionNumber("1.12");
    VersionNumber INFO_FORMAT = new VersionNumber("1.13");
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    public CliDockerDriver(DockerHostConfig dockerHost) throws IOException, InterruptedException {
        this.dockerHost = dockerHost;
        this.version = new VersionNumber(this.serverVersion(TaskListener.NULL));
    }

    @Override
    public void close() throws IOException {
        this.dockerHost.close();
    }

    @Override
    public String createVolume(TaskListener listener) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"volume", "create"});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String volume = out.toString(UTF_8).trim();
        if (status != 0) {
            throw new IOException("Failed to create docker volume");
        }
        return volume;
    }

    @Override
    public boolean hasVolume(TaskListener listener, String name) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"volume", "inspect", "-f", "'{{.Name}}'", name});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        return status == 0;
    }

    @Override
    public boolean hasContainer(TaskListener listener, String id) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"inspect", "-f", "'{{.Id}}'", id});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        return status == 0;
    }

    @Override
    public Container launchRemotingContainer(TaskListener listener, String image, String volume, SlaveComputer computer) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"create", "--interactive"}).add("--log-driver=none").add(new String[]{"--env", "TMPDIR=/home/jenkins/.jenkins/.tmp"}).add(new String[]{"--user", "10000:10000"}).add(new String[]{"--volume", volume + ":" + "/home/jenkins/.jenkins/"}).add(image).add("java").add("-Djava.io.tmpdir=/home/jenkins/.jenkins/.tmp").add("-jar").add("/home/jenkins/.jenkins/slave.jar");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String containerId = out.toString(UTF_8).trim();
        if (status != 0) {
            throw new IOException("Failed to create docker image");
        }
        this.putFileContent((Launcher)launcher, containerId, "/home/jenkins/.jenkins/", "slave.jar", new Slave.JnlpJar("slave.jar").readFully());
        Container remotingContainer = new Container(image, containerId);
        args = new ArgumentListBuilder().add("start").add(new String[]{"--interactive", "--attach", remotingContainer.getId()});
        this.prependArgs(args);
        new CommandLauncher(args.toString(), this.dockerHost.getEnvironment()).launch(computer, listener);
        return remotingContainer;
    }

    @Override
    public Container launchBuildContainer(TaskListener listener, String image, Container remotingContainer, List<String> mounts) throws IOException, InterruptedException {
        Container buildContainer = new Container(image);
        ArgumentListBuilder args = new ArgumentListBuilder().add("create").add(new String[]{"--env", "TMPDIR=/home/jenkins/.jenkins/.tmp"}).add(new String[]{"--workdir", "/home/jenkins/.jenkins/"}).add(new String[]{"--volumes-from", remotingContainer.getId()}).add("--net=container:" + remotingContainer.getId()).add("--ipc=container:" + remotingContainer.getId()).add(new String[]{"--user", "10000:10000"});
        for (String mount : mounts) {
            args.add(new String[]{"-v", mount});
        }
        args.add(buildContainer.getImageName());
        args.add(new String[]{"/trampoline", "wait"});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String containerId = out.toString(UTF_8).trim();
        buildContainer.setId(containerId);
        if (status != 0) {
            throw new IOException("Failed to run docker image");
        }
        this.injectJenkinsUnixGroup((Launcher)launcher, containerId);
        this.injectJenkinsUnixUser((Launcher)launcher, containerId);
        this.injectTrampoline((Launcher)launcher, containerId);
        status = this.launchDockerCLI((Launcher)launcher, new ArgumentListBuilder().add(new String[]{"start", containerId})).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        if (status != 0) {
            throw new IOException("Failed to run docker image");
        }
        return buildContainer;
    }

    protected void injectJenkinsUnixGroup(Launcher launcher, String containerId) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getFileContent(launcher, containerId, "/etc/group", out);
        out.write("jenkins:x:10000:\n".getBytes(StandardCharsets.UTF_8));
        this.putFileContent(launcher, containerId, "/etc", "group", out.toByteArray());
    }

    protected void injectJenkinsUnixUser(Launcher launcher, String containerId) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getFileContent(launcher, containerId, "/etc/passwd", out);
        out.write("jenkins:x:10000:10000::/home/jenkins:/bin/false\n".getBytes(StandardCharsets.UTF_8));
        this.putFileContent(launcher, containerId, "/etc", "passwd", out.toByteArray());
    }

    protected void injectTrampoline(Launcher launcher, String containerId) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/it/dockins/dockerslaves/trampoline"), (OutputStream)out);
        this.putFileContent(launcher, containerId, "/", "trampoline", out.toByteArray(), 555);
    }

    protected void getFileContent(Launcher launcher, String containerId, String filename, OutputStream outputStream) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"cp", containerId + ":" + filename, "-"});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int status = this.launchDockerCLI(launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        if (status != 0) {
            throw new IOException("Failed to get file");
        }
        TarInputStream tar = new TarInputStream((InputStream)new ByteArrayInputStream(out.toByteArray()));
        tar.getNextEntry();
        tar.copyEntryContents(outputStream);
        tar.close();
    }

    protected int putFileContent(Launcher launcher, String containerId, String path, String filename, byte[] content) throws IOException, InterruptedException {
        return this.putFileContent(launcher, containerId, path, filename, content, null);
    }

    protected int putFileContent(Launcher launcher, String containerId, String path, String filename, byte[] content, Integer mode) throws IOException, InterruptedException {
        TarEntry entry = new TarEntry(filename);
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setSize((long)content.length);
        if (mode != null) {
            entry.setMode(mode.intValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TarOutputStream tar = new TarOutputStream((OutputStream)out);
        tar.putNextEntry(entry);
        tar.write(content);
        tar.closeEntry();
        tar.close();
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"cp", "-", containerId + ":" + path});
        return this.launchDockerCLI(launcher, args).stdin((InputStream)new ByteArrayInputStream(out.toByteArray())).stderr((OutputStream)launcher.getListener().getLogger()).join();
    }

    @Override
    public Proc execInContainer(TaskListener listener, String containerId, Launcher.ProcStarter starter) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"exec", containerId});
        if (starter.pwd() != null) {
            args.add(new String[]{"/trampoline", "cdexec", starter.pwd().getRemote()});
        }
        args.add("env").add(starter.envs());
        List originalCmds = starter.cmds();
        boolean[] originalMask = starter.masks();
        for (int i = 0; i < originalCmds.size(); ++i) {
            boolean masked = originalMask == null ? false : (i < originalMask.length ? originalMask[i] : false);
            args.add((String)originalCmds.get(i), masked);
        }
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        Launcher.ProcStarter procStarter = this.launchDockerCLI((Launcher)launcher, args);
        if (starter.stdout() != null) {
            procStarter.stdout(starter.stdout());
        }
        return procStarter.start();
    }

    @Override
    public int removeContainer(TaskListener listener, Container instance) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"rm", "-f", instance.getId()});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        return status;
    }

    @Override
    public Container launchSideContainer(TaskListener listener, String image, Container remotingContainer, List<String> mounts) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add("create").add(new String[]{"--volumes-from", remotingContainer.getId()}).add("--net=container:" + remotingContainer.getId()).add("--ipc=container:" + remotingContainer.getId());
        for (String mount : mounts) {
            args.add(new String[]{"-v", mount});
        }
        args.add(image);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String containerId = out.toString(UTF_8).trim();
        if (status != 0) {
            throw new IOException("Failed to run docker image");
        }
        this.launchDockerCLI((Launcher)launcher, new ArgumentListBuilder().add(new String[]{"start", containerId})).start();
        return new Container(image, containerId);
    }

    @Override
    public void pullImage(TaskListener listener, String image) throws IOException, InterruptedException {
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        ArgumentListBuilder args = new ArgumentListBuilder().add("pull").add(image);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)launcher.getListener().getLogger()).join();
        if (status != 0) {
            throw new IOException("Failed to pull image " + image);
        }
    }

    @Override
    public boolean checkImageExists(TaskListener listener, String image) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add("inspect").add(new String[]{"-f", "'{{.Id}}'"}).add(image);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        return this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join() == 0;
    }

    @Override
    public int buildDockerfile(TaskListener listener, String dockerfilePath, String tag, boolean pull) throws IOException, InterruptedException {
        String pullOption = "--pull=";
        pullOption = pull ? pullOption + "true" : pullOption + "false";
        ArgumentListBuilder args = new ArgumentListBuilder().add("build").add(pullOption).add(new String[]{"-t", tag}).add(dockerfilePath);
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        return this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)launcher.getListener().getLogger()).join();
    }

    @Override
    public String serverVersion(TaskListener listener) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"version", "-f", "{{.Server.Version}}"});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String version = out.toString(UTF_8).trim();
        if (status != 0) {
            throw new IOException("Failed to connect to docker API");
        }
        return version;
    }

    public boolean usesSwarmMode(TaskListener listener) throws IOException, InterruptedException {
        if (this.version.isOlderThan(this.SWARM)) {
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"docker", "info"});
        if (!this.version.isOlderThan(this.INFO_FORMAT)) {
            args.add(new String[]{"--format", "{{.Swarm}}"});
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = this.launchDockerCLI((Launcher)launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        if (status != 0) {
            throw new IOException("Failed to connect to docker API");
        }
        return out.toString(UTF_8).contains("Swarm: active");
    }

    public void prependArgs(ArgumentListBuilder args) {
        DockerServerEndpoint endpoint = this.dockerHost.getEndpoint();
        if (endpoint.getUri() != null) {
            args.prepend(new String[]{"-H", endpoint.getUri()});
        } else {
            LOGGER.log(Level.FINE, "no specified docker host");
        }
        args.prepend(new String[]{"docker"});
    }

    private Launcher.ProcStarter launchDockerCLI(Launcher launcher, ArgumentListBuilder args) {
        this.prependArgs(args);
        return launcher.launch().envs((Map)this.dockerHost.getEnvironment()).cmds(args).quiet(!verbose);
    }
}

