/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.drivers;

import hudson.Extension;
import hudson.model.Job;
import it.dockins.dockerslaves.DefaultDockerHostSource;
import it.dockins.dockerslaves.drivers.CliDockerDriver;
import it.dockins.dockerslaves.spi.DockerDriver;
import it.dockins.dockerslaves.spi.DockerDriverFactory;
import it.dockins.dockerslaves.spi.DockerDriverFactoryDescriptor;
import it.dockins.dockerslaves.spi.DockerHostSource;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.kohsuke.stapler.DataBoundConstructor;

public class PlainDockerAPIDockerDriverFactory
extends DockerDriverFactory {
    private final DockerHostSource dockerHostSource;

    @DataBoundConstructor
    public PlainDockerAPIDockerDriverFactory(DockerHostSource dockerHostSource) {
        this.dockerHostSource = dockerHostSource;
    }

    public PlainDockerAPIDockerDriverFactory(DockerServerEndpoint dockerHost) {
        this(new DefaultDockerHostSource(dockerHost));
    }

    public DockerHostSource getDockerHostSource() {
        return this.dockerHostSource;
    }

    @Override
    public DockerDriver forJob(Job context) throws IOException, InterruptedException {
        return new CliDockerDriver(this.dockerHostSource.getDockerHost(context));
    }

    @Extension
    public static class DescriptorImp
    extends DockerDriverFactoryDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "Docker CLI (require docker executable on PATH)";
        }
    }
}

