/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.pipeline;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import it.dockins.dockerslaves.pipeline.DockerNodeStepExecution;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerNodeStep
extends AbstractStepImpl {
    private List<String> sideContainers;
    @CheckForNull
    private final String image;

    @DataBoundConstructor
    public DockerNodeStep(String image) {
        this.image = Util.fixEmptyAndTrim((String)image);
    }

    @CheckForNull
    public String getImage() {
        return this.image;
    }

    public List<String> getSideContainers() {
        return this.sideContainers;
    }

    @DataBoundSetter
    public void setSideContainers(List<String> sideContainers) {
        this.sideContainers = sideContainers;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(DockerNodeStepExecution.class);
        }

        public String getFunctionName() {
            return "dockerNode";
        }

        public String getDisplayName() {
            return "Allocate a docker node";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getProvidedContext() {
            return ImmutableSet.of(Executor.class, Computer.class, FilePath.class, EnvVars.class, Node.class, Launcher.class, (Object[])new Class[0]);
        }
    }
}

