/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.spec;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import it.dockins.dockerslaves.spec.ContainerDefinition;
import it.dockins.dockerslaves.spec.SideContainerDefinition;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ContainerSetDefinition
extends JobProperty {
    private final ContainerDefinition buildHostImage;
    private final List<SideContainerDefinition> sideContainers;

    @DataBoundConstructor
    public ContainerSetDefinition(ContainerDefinition buildHostImage, List<SideContainerDefinition> sideContainers) {
        this.buildHostImage = buildHostImage;
        this.sideContainers = sideContainers == null ? Collections.emptyList() : sideContainers;
    }

    private Object readResolve() {
        return new ContainerSetDefinition(this.buildHostImage, this.sideContainers);
    }

    public ContainerDefinition getBuildHostImage() {
        return this.buildHostImage;
    }

    public List<SideContainerDefinition> getSideContainers() {
        return this.sideContainers;
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Containers to host the build";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.isNullObject()) {
                return null;
            }
            JSONObject containersDefinition = formData.getJSONObject("containersDefinition");
            if (containersDefinition.isNullObject()) {
                return null;
            }
            return (JobProperty)req.bindJSON(ContainerSetDefinition.class, containersDefinition);
        }
    }
}

