/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.spec;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import it.dockins.dockerslaves.spec.ContainerDefinition;
import it.dockins.dockerslaves.spi.DockerDriver;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerfileContainerDefinition
extends ContainerDefinition {
    private final String dockerfile;
    private final String contextPath;
    private final boolean forcePull;
    private transient String image;
    private static MasterToSlaveFileCallable<byte[]> FILECONTENT = new MasterToSlaveFileCallable<byte[]>(){

        public byte[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return FileUtils.readFileToByteArray((File)f);
        }
    };

    @DataBoundConstructor
    public DockerfileContainerDefinition(String contextPath, String dockerfile, boolean forcePull) {
        this.contextPath = contextPath;
        this.dockerfile = dockerfile;
        this.forcePull = forcePull;
    }

    public String getDockerfile() {
        return this.dockerfile;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getImage(DockerDriver driver, Launcher.ProcStarter procStarter, TaskListener listener) throws IOException, InterruptedException {
        boolean pull = this.forcePull;
        if (this.image != null) {
            return this.image;
        }
        String tag = Long.toHexString(System.nanoTime());
        FilePath workspace = procStarter.pwd();
        FilePath pathToContext = workspace.child(this.contextPath);
        if (!pathToContext.exists()) {
            throw new IOException(pathToContext.getRemote() + " does not exists.");
        }
        FilePath pathToDockerfile = pathToContext.child(this.dockerfile);
        if (!pathToDockerfile.exists()) {
            throw new IOException(pathToContext.getRemote() + " does not exists.");
        }
        File context = Util.createTempDir();
        pathToContext.copyRecursiveTo(new FilePath(context));
        pathToDockerfile.copyTo(new FilePath(new File(context, "Dockerfile")));
        if (driver.buildDockerfile(listener, context.getAbsolutePath(), tag, pull) != 0) {
            throw new IOException("Failed to build image from Dockerfile " + this.dockerfile);
        }
        Util.deleteRecursive((File)context);
        this.image = tag;
        return tag;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ContainerDefinition> {
        public String getDisplayName() {
            return "Build Dockerfile";
        }
    }
}

