/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.spec;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import it.dockins.dockerslaves.spec.ContainerDefinition;
import it.dockins.dockerslaves.spi.DockerDriver;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class ImageIdContainerDefinition
extends ContainerDefinition {
    private final String image;
    private final boolean forcePull;

    @DataBoundConstructor
    public ImageIdContainerDefinition(String image, boolean forcePull) {
        this.image = image;
        this.forcePull = forcePull;
    }

    public String getImage() {
        return this.image;
    }

    @Override
    public String getImage(DockerDriver driver, Launcher.ProcStarter procStarter, TaskListener listener) throws IOException, InterruptedException {
        boolean pull = this.forcePull;
        boolean result = driver.checkImageExists(listener, this.image);
        if (!result) {
            pull = true;
        }
        if (pull) {
            listener.getLogger().println("Pulling docker image " + this.image);
            driver.pullImage(listener, this.image);
        }
        return this.image;
    }

    @Extension(ordinal=99.0)
    public static class DescriptorImpl
    extends Descriptor<ContainerDefinition> {
        public String getDisplayName() {
            return "Docker image";
        }
    }
}

