/*
 * Decompiled with CFR 0.152.
 */
package it.dockins.dockerslaves.spi;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import java.io.Closeable;
import java.io.IOException;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;

public class DockerHostConfig
implements Closeable {
    private final DockerServerEndpoint endpoint;
    private final KeyMaterial keys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerHostConfig(DockerServerEndpoint endpoint, Item context) throws IOException, InterruptedException {
        this.endpoint = endpoint;
        SecurityContext impersonate = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            this.keys = endpoint.newKeyMaterialFactory(context, (VirtualChannel)FilePath.localChannel).materialize();
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)impersonate);
        }
    }

    public DockerServerEndpoint getEndpoint() {
        return this.endpoint;
    }

    public EnvVars getEnvironment() {
        return this.keys.env();
    }

    @Override
    public void close() throws IOException {
        this.keys.close();
    }
}

