/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class HttpBasedServiceCredentialsAuthenticationHandler
implements AuthenticationHandler,
InitializingBean {
    private static final String PROTOCOL_HTTPS = "https";
    private static final int[] DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202};
    private int[] acceptableCodes;
    private boolean requireSecure = true;
    private final Log log = LogFactory.getLog(this.getClass());
    private HttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(Credentials credentials) {
        HttpBasedServiceCredentials serviceCredentials = (HttpBasedServiceCredentials)credentials;
        if (this.requireSecure && !serviceCredentials.getCallbackUrl().getProtocol().equals(PROTOCOL_HTTPS)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Authentication failed because url was not secure.");
            }
            return false;
        }
        this.log.debug((Object)("Attempting to resolve credentials for " + serviceCredentials));
        GetMethod getMethod = new GetMethod(serviceCredentials.getCallbackUrl().toExternalForm());
        int responseCode = 500;
        try {
            this.httpClient.executeMethod((HttpMethod)getMethod);
            responseCode = getMethod.getStatusCode();
            for (int i = 0; i < this.acceptableCodes.length; ++i) {
                if (responseCode != this.acceptableCodes[i]) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        finally {
            getMethod.releaseConnection();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication failed because returned status code was [" + responseCode + "]"));
        }
        return false;
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && HttpBasedServiceCredentials.class.isAssignableFrom(credentials.getClass());
    }

    public void setAcceptableCodes(int[] acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setRequireSecure(boolean requireSecure) {
        this.requireSecure = requireSecure;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.acceptableCodes == null) {
            this.acceptableCodes = DEFAULT_ACCEPTABLE_CODES;
        }
        Assert.notNull((Object)this.httpClient, (String)"Note, this behavior has changed from the CAS 3.0.6 behavior.  You now MUST specify an instance of HttpClient.  Before it would create an instance for you.");
    }
}

