/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.remoting.server;

import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.validation.Assertion;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public final class RemoteCentralAuthenticationService
implements CentralAuthenticationService,
InitializingBean {
    private CentralAuthenticationService centralAuthenticationService;
    private Validator[] validators;

    public String createTicketGrantingTicket(Credentials credentials) throws TicketException {
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        Errors errors = this.validateCredentials(credentials);
        if (errors.hasErrors()) {
            throw new IllegalArgumentException("Error validating credentials: " + errors.toString());
        }
        return this.centralAuthenticationService.createTicketGrantingTicket(credentials);
    }

    public String grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        return this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service);
    }

    public String grantServiceTicket(String ticketGrantingTicketId, Service service, Credentials credentials) throws TicketException {
        Errors errors;
        if (credentials != null && (errors = this.validateCredentials(credentials)).hasErrors()) {
            throw new IllegalArgumentException("Error validating credentials: " + errors.toString());
        }
        return this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credentials);
    }

    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        return this.centralAuthenticationService.validateServiceTicket(serviceTicketId, service);
    }

    public void destroyTicketGrantingTicket(String ticketGrantingTicketId) {
        this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
    }

    public String delegateTicketGrantingTicket(String serviceTicketId, Credentials credentials) throws TicketException {
        Errors errors = this.validateCredentials(credentials);
        if (errors.hasErrors()) {
            throw new IllegalArgumentException("Error validating credentials: " + errors.toString());
        }
        return this.centralAuthenticationService.delegateTicketGrantingTicket(serviceTicketId, credentials);
    }

    private Errors validateCredentials(Credentials credentials) {
        BindException errors = new BindException((Object)credentials, "credentials");
        if (this.validators == null) {
            return errors;
        }
        for (int i = 0; i < this.validators.length; ++i) {
            if (!this.validators[i].supports(credentials.getClass())) continue;
            ValidationUtils.invokeValidator((Validator)this.validators[i], (Object)credentials, (Errors)errors);
        }
        return errors;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.centralAuthenticationService, (String)"centralAuthenticationService is a required property.");
    }
}

