/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.support;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistryManager;
import org.jasig.cas.services.ServiceRegistryReloader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public final class SpringApplicationContextServiceRegistryReloader
implements ServiceRegistryReloader,
InitializingBean,
ResourceLoaderAware {
    private static final String DEFAULT_FILE_NAME = "services.xml";
    private final Log log = LogFactory.getLog(this.getClass());
    private ServiceRegistryManager serviceRegistryManager;
    private File serviceRegistryFile;
    private String fileName;
    private long timeLastModified = 0L;
    private ResourceLoader resourceLoader;
    private ClassPathXmlApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadServiceRegistry() {
        long currentTimeLastModified;
        if (this.log.isDebugEnabled()) {
            this.log.info((Object)"Checking if service list changed since last reload.");
        }
        if (this.timeLastModified != (currentTimeLastModified = this.serviceRegistryFile.lastModified())) {
            this.timeLastModified = currentTimeLastModified;
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Last modified time changed on " + this.serviceRegistryFile.getName() + ".  File most likely modified.  Regenerating ServiceRegistry."));
            }
            ServiceRegistryManager serviceRegistryManager = this.serviceRegistryManager;
            synchronized (serviceRegistryManager) {
                this.applicationContext.refresh();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Clearing out previous ServiceRegistry entries.");
                }
                this.serviceRegistryManager.clear();
                Iterator iter = this.applicationContext.getBeansOfType(RegisteredService.class).values().iterator();
                while (iter.hasNext()) {
                    RegisteredService authenticatedService = (RegisteredService)iter.next();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding [" + authenticatedService.getId() + "] to ServiceRegistry"));
                    }
                    this.serviceRegistryManager.addService(authenticatedService);
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.serviceRegistryManager, (String)"serviceRegistryManager is a required property.");
        if (this.fileName == null) {
            this.log.info((Object)("No fileName provided for " + this.getClass().getName() + ".  Using default file name: " + DEFAULT_FILE_NAME));
            this.fileName = DEFAULT_FILE_NAME;
        }
        this.serviceRegistryFile = this.resourceLoader.getResource("classpath:" + this.fileName).getFile();
        this.applicationContext = new ClassPathXmlApplicationContext(this.fileName);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setServiceRegistryManager(ServiceRegistryManager serviceRegistryManager) {
        this.serviceRegistryManager = serviceRegistryManager;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

