/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.stat.advice;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.stat.TicketStatisticsManager;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class LogTicketStatisticsAfterReturningAdvice
implements AfterReturningAdvice,
InitializingBean {
    private static final String PROXY_TICKET_METHOD = "grantServiceTicket";
    private Properties statsStateMutators = new Properties();
    private TicketStatisticsManager ticketStatsManager;
    private TicketRegistry ticketRegistry;

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        ServiceTicket serviceTicket;
        if (returnValue == null) {
            return;
        }
        String statsStateMutatorMethodName = this.statsStateMutators.getProperty(method.getName());
        if (statsStateMutatorMethodName == null) {
            return;
        }
        if (method.getName().equals(PROXY_TICKET_METHOD) && (serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket((String)returnValue)).getGrantingTicket().getAuthentication().getPrincipal() instanceof Service && serviceTicket.getGrantingTicket().getGrantingTicket() != null) {
            this.ticketStatsManager.incrementNumberOfProxyTicketsVended();
            return;
        }
        Method statsStateMutatorMethod = this.ticketStatsManager.getClass().getMethod(statsStateMutatorMethodName, null);
        statsStateMutatorMethod.invoke((Object)this.ticketStatsManager, null);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.statsStateMutators, (String)"statsStateMutators is a required property.");
        Assert.notEmpty((Map)this.statsStateMutators, (String)"statsStateMutators is a required property.");
        Assert.notNull((Object)this.ticketStatsManager, (String)"ticketStatsManager is a required property.");
        Assert.notNull((Object)this.ticketRegistry, (String)"ticketRegistry is a required property.");
    }

    public void setTicketStatsManager(TicketStatisticsManager ticketStatsManager) {
        this.ticketStatsManager = ticketStatsManager;
    }

    public void setStatsStateMutators(Properties statsStateMutators) {
        this.statsStateMutators = statsStateMutators;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

