/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.springframework.util.Assert;

public final class TicketGrantingTicketImpl
extends AbstractTicket
implements TicketGrantingTicket {
    private static final long serialVersionUID = -8673232562725683059L;
    private final Authentication authentication;
    private boolean expired = false;

    public TicketGrantingTicketImpl(String id, TicketGrantingTicket ticketGrantingTicket, Authentication authentication, ExpirationPolicy policy) {
        super(id, ticketGrantingTicket, policy);
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.authentication = authentication;
    }

    public TicketGrantingTicketImpl(String id, Authentication authentication, ExpirationPolicy policy) {
        this(id, null, authentication, policy);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public synchronized ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
        ServiceTicketImpl serviceTicket = new ServiceTicketImpl(id, this, service, this.getCountOfUses() == 0 || credentialsProvided, expirationPolicy);
        this.updateState();
        return serviceTicket;
    }

    public boolean isRoot() {
        return this.getGrantingTicket() == null;
    }

    public void expire() {
        this.expired = true;
    }

    public boolean isExpiredInternal() {
        return this.expired || this.getGrantingTicket() != null && this.getGrantingTicket().isExpired();
    }

    public List getChainedAuthentications() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        if (this.getGrantingTicket() == null) {
            list.add(this.getAuthentication());
            return Collections.unmodifiableList(list);
        }
        list.add(this.getAuthentication());
        list.addAll(this.getGrantingTicket().getChainedAuthentications());
        return Collections.unmodifiableList(list);
    }

    public boolean equals(Object object) {
        if (object == null || !TicketGrantingTicket.class.isAssignableFrom(object.getClass())) {
            return false;
        }
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)object;
        return new EqualsBuilder().append((Object)ticketGrantingTicket.getAuthentication(), (Object)this.getAuthentication()).append((Object)ticketGrantingTicket.getChainedAuthentications(), (Object)this.getChainedAuthentications()).append(ticketGrantingTicket.getCreationTime(), this.getCreationTime()).append((Object)ticketGrantingTicket.getGrantingTicket(), (Object)this.getGrantingTicket()).append((Object)ticketGrantingTicket.getId(), (Object)this.getId()).append(ticketGrantingTicket.isExpired(), this.isExpired()).append(ticketGrantingTicket.isRoot(), this.isRoot()).isEquals();
    }
}

