/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.springframework.util.Assert;

public final class DefaultTicketRegistry
extends AbstractTicketRegistry {
    private final Map cache = new HashMap();

    public void addTicket(Ticket ticket) {
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added ticket [" + ticket.getId() + "] to registry."));
        }
        this.cache.put(ticket.getId(), ticket);
    }

    public Ticket getTicket(String ticketId) {
        Ticket ticket;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to retrieve ticket [" + ticketId + "]"));
        }
        if ((ticket = (Ticket)this.cache.get(ticketId)) != null) {
            this.log.debug((Object)("Ticket [" + ticketId + "] found in registry."));
        }
        return ticket;
    }

    public boolean deleteTicket(String ticketId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing ticket [" + ticketId + "] from registry"));
        }
        return this.cache.remove(ticketId) != null;
    }

    public Collection getTickets() {
        return Collections.unmodifiableCollection(this.cache.values());
    }
}

