/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.jboss.cache.CacheException;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class JBossCacheTicketRegistry
extends AbstractTicketRegistry
implements InitializingBean {
    private static final String FQN_TICKET = "ticket";
    private TreeCache cache;

    public void addTicket(Ticket ticket) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding ticket to registry for: " + ticket.getId()));
            }
            this.cache.put(FQN_TICKET, (Object)ticket.getId(), (Object)ticket);
        }
        catch (CacheException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean deleteTicket(String ticketId) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing ticket from registry for: " + ticketId));
            }
            return this.cache.remove(FQN_TICKET, (Object)ticketId) != null;
        }
        catch (CacheException e) {
            this.log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public Ticket getTicket(String ticketId) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving ticket from registry for: " + ticketId));
            }
            return this.getProxiedTicketInstance((Ticket)this.cache.get(FQN_TICKET, (Object)ticketId));
        }
        catch (CacheException e) {
            this.log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTickets() {
        try {
            Node node = this.cache.get(FQN_TICKET);
            if (node == null) {
                return Collections.EMPTY_LIST;
            }
            Set keys = node.getDataKeys();
            ArrayList<Object> list = new ArrayList<Object>();
            TreeCache treeCache = this.cache;
            synchronized (treeCache) {
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    list.add(node.get(iter.next()));
                }
            }
            return list;
        }
        catch (CacheException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache cannot be null.");
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    private Ticket getProxiedTicketInstance(Ticket ticket) {
        if (ticket == null) {
            return null;
        }
        if (ticket instanceof ServiceTicket) {
            return new ProxiedServiceTicket((ServiceTicket)ticket, this.cache);
        }
        return new ProxiedTicketGrantingTicket((TicketGrantingTicket)ticket, this.cache);
    }

    private final class ProxiedTicketGrantingTicket
    implements TicketGrantingTicket {
        private static final long serialVersionUID = -4361481214176025025L;
        private final TicketGrantingTicket ticket;
        private final TreeCache cache;

        protected ProxiedTicketGrantingTicket(TicketGrantingTicket ticket, TreeCache cache) {
            this.ticket = ticket;
            this.cache = cache;
        }

        public long getCreationTime() {
            return this.ticket.getCreationTime();
        }

        public TicketGrantingTicket getGrantingTicket() {
            return this.ticket.getGrantingTicket();
        }

        public String getId() {
            return this.ticket.getId();
        }

        public boolean isExpired() {
            return this.ticket.isExpired();
        }

        public void expire() {
            this.ticket.expire();
            try {
                this.cache.put(JBossCacheTicketRegistry.FQN_TICKET, (Object)this.ticket.getId(), (Object)this.ticket);
            }
            catch (CacheException e) {
                throw new RuntimeException(e);
            }
        }

        public Authentication getAuthentication() {
            return this.ticket.getAuthentication();
        }

        public List getChainedAuthentications() {
            return this.ticket.getChainedAuthentications();
        }

        public ServiceTicket grantServiceTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean credentialsProvided) {
            ServiceTicket serviceTicket = this.ticket.grantServiceTicket(id, service, expirationPolicy, credentialsProvided);
            try {
                this.cache.put(JBossCacheTicketRegistry.FQN_TICKET, (Object)this.ticket.getId(), (Object)this.ticket);
            }
            catch (CacheException e) {
                throw new RuntimeException(e);
            }
            return serviceTicket;
        }

        public boolean isRoot() {
            return this.ticket.isRoot();
        }

        public boolean equals(Object obj) {
            return this.ticket.equals(obj);
        }

        public String toString() {
            return this.ticket.toString();
        }
    }

    private final class ProxiedServiceTicket
    implements ServiceTicket {
        private static final long serialVersionUID = -8212338455270445676L;
        private final ServiceTicket serviceTicket;
        private final TreeCache cache;

        protected ProxiedServiceTicket(ServiceTicket serviceTicket, TreeCache cache) {
            this.serviceTicket = serviceTicket;
            this.cache = cache;
        }

        public Service getService() {
            return this.serviceTicket.getService();
        }

        public TicketGrantingTicket grantTicketGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
            return this.serviceTicket.grantTicketGrantingTicket(id, authentication, expirationPolicy);
        }

        public boolean isFromNewLogin() {
            return this.serviceTicket.isFromNewLogin();
        }

        public long getCreationTime() {
            return this.serviceTicket.getCreationTime();
        }

        public TicketGrantingTicket getGrantingTicket() {
            return this.serviceTicket.getGrantingTicket();
        }

        public String getId() {
            return this.serviceTicket.getId();
        }

        public boolean isValidFor(Service service) {
            boolean result = this.serviceTicket.isValidFor(service);
            try {
                this.cache.put(JBossCacheTicketRegistry.FQN_TICKET, (Object)this.serviceTicket.getId(), (Object)this.serviceTicket);
            }
            catch (CacheException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public boolean isExpired() {
            return this.serviceTicket.isExpired();
        }

        public boolean equals(Object obj) {
            return this.serviceTicket.equals(obj);
        }

        public String toString() {
            return this.serviceTicket.toString();
        }
    }
}

