/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.SecureRandom;
import org.jasig.cas.util.RandomStringGenerator;

public final class DefaultRandomStringGenerator
implements RandomStringGenerator {
    private static final char[] PRINTABLE_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679".toCharArray();
    private static final int DEFAULT_MAX_RANDOM_LENGTH = 35;
    private SecureRandom randomizer = new SecureRandom();
    private final int maximumRandomLength;

    public DefaultRandomStringGenerator() {
        this.maximumRandomLength = 35;
    }

    public DefaultRandomStringGenerator(int maxRandomLength) {
        this.maximumRandomLength = maxRandomLength;
    }

    public int getMinLength() {
        return this.maximumRandomLength;
    }

    public int getMaxLength() {
        return this.maximumRandomLength;
    }

    public String getNewString() {
        byte[] random = new byte[this.maximumRandomLength];
        this.randomizer.nextBytes(random);
        return this.convertBytesToString(random);
    }

    private String convertBytesToString(byte[] random) {
        char[] output = new char[random.length];
        for (int i = 0; i < random.length; ++i) {
            int index = Math.abs(random[i] % PRINTABLE_CHARACTERS.length);
            output[i] = PRINTABLE_CHARACTERS[index];
        }
        return new String(output);
    }
}

