/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.contrib.ssl.StrictSSLProtocolSocketFactory;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public final class HttpClient3FactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private Log log = LogFactory.getLog(this.getClass());
    private HttpClient httpClient;
    private MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
    private HttpClientParams httpClientParams = new HttpClientParams();
    private boolean useStrictHostNameChecking = true;
    private HttpConnectionManagerParams httpConnectionManagerParams = new HttpConnectionManagerParams();

    public void afterPropertiesSet() throws Exception {
        this.httpClient = new HttpClient(this.httpClientParams, (HttpConnectionManager)this.manager);
        this.manager.setParams(this.httpConnectionManagerParams);
        this.httpConnectionManagerParams.setStaleCheckingEnabled(true);
        if (!this.useStrictHostNameChecking) {
            this.log.warn((Object)"Strict host name checking disabled.  DO NOT DO THIS IN PRODUCTION.");
        }
        StrictSSLProtocolSocketFactory factory = new StrictSSLProtocolSocketFactory();
        factory.setHostnameVerification(this.useStrictHostNameChecking);
        Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)factory, 443);
        Protocol.registerProtocol((String)"https", (Protocol)myhttps);
    }

    public void destroy() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Shutting down MultiThreadedHttpConnectionManager...");
        }
        this.manager.shutdown();
    }

    public Object getObject() throws Exception {
        return this.httpClient;
    }

    public Class getObjectType() {
        return HttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setStrict(boolean strict) {
        if (strict) {
            this.httpClientParams.makeStrict();
        } else {
            this.httpClientParams.makeLenient();
        }
    }

    public void setAuthenticationPreemptive(boolean value) {
        this.httpClientParams.setAuthenticationPreemptive(value);
    }

    public void setConnectionManagerTimeout(long timeout) {
        this.httpClientParams.setConnectionManagerTimeout(timeout);
    }

    public void setContentCharset(String charset) {
        this.httpClientParams.setContentCharset(charset);
    }

    public void setCookiePolicy(String policy) {
        this.httpClientParams.setCookiePolicy(policy);
    }

    public void setCredentialCharset(String charset) {
        this.httpClientParams.setCredentialCharset(charset);
    }

    public void setHttpElementCharset(String charset) {
        this.httpClientParams.setHttpElementCharset(charset);
    }

    public void setSoTimeout(int timeout) {
        this.httpClientParams.setSoTimeout(timeout);
        this.httpConnectionManagerParams.setSoTimeout(timeout);
    }

    public void setVersion(HttpVersion version) {
        this.httpClientParams.setVersion(version);
    }

    public void setDefaultMaxConnectionsPerHost(int maxHostConnections) {
        this.httpConnectionManagerParams.setDefaultMaxConnectionsPerHost(maxHostConnections);
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.httpConnectionManagerParams.setMaxTotalConnections(maxTotalConnections);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.httpConnectionManagerParams.setConnectionTimeout(connectionTimeout);
    }

    public void setUseStrictHostNameChecking(boolean useStrictHostNameChecking) {
        this.useStrictHostNameChecking = useStrictHostNameChecking;
    }
}

