/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public final class JBossCacheFactoryBean
implements FactoryBean,
DisposableBean,
InitializingBean {
    private Log log = LogFactory.getLog(this.getClass());
    private TreeCache cache;
    private Resource configLocation;

    public Object getObject() throws Exception {
        return this.cache;
    }

    public Class getObjectType() {
        return TreeCache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void destroy() throws Exception {
        this.log.info((Object)"Shutting down TreeCache service.");
        this.cache.stopService();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.configLocation, (String)"configLocation cannot be null.");
        this.cache = new TreeCache();
        PropertyConfigurator propertyConfigurator = new PropertyConfigurator();
        propertyConfigurator.configure((Object)this.cache, this.configLocation.getInputStream());
        this.log.info((Object)"Starting TreeCache service.");
        this.cache.startService();
    }
}

