/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.util;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public final class ThrottledSubmissionByIpAddressHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements InitializingBean {
    private static final int MAX_SIZE_OF_MAP_ARRAY = 256;
    private static final BigInteger DEFAULT_FAILURE_THRESHHOLD = BigInteger.valueOf(100L);
    private static final int DEFAULT_FAILURE_TIMEOUT = 60;
    protected static final BigInteger ONE = BigInteger.valueOf(1L);
    private Map[] restrictedIpAddressMaps;
    private BigInteger failureThreshhold = DEFAULT_FAILURE_THRESHHOLD;
    int failureTimeout = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        Map quadMap;
        if (request.getMethod().equals("GET") || !modelAndView.getViewName().equals("casLoginView")) {
            return;
        }
        String remoteAddr = request.getRemoteAddr();
        String lastQuad = remoteAddr.substring(remoteAddr.lastIndexOf(".") + 1);
        int intVersionOfLastQuad = Integer.parseInt(lastQuad);
        Map map = quadMap = this.restrictedIpAddressMaps[intVersionOfLastQuad - 1];
        synchronized (map) {
            BigInteger original = (BigInteger)quadMap.get(lastQuad);
            BigInteger integer = ONE;
            if (original != null) {
                integer = original.add(ONE);
            }
            quadMap.put(lastQuad, integer);
            if (integer.compareTo(this.failureThreshhold) == 1) {
                modelAndView.setViewName("casFailureAuthenticationThreshhold");
            }
        }
    }

    public void setFailureThreshhold(BigInteger failureThreshhold) {
        this.failureThreshhold = failureThreshhold;
    }

    public void setFailureTimeout(int failureTimeout) {
        this.failureTimeout = failureTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        this.restrictedIpAddressMaps = new Map[256];
        for (int i = 0; i < 256; ++i) {
            this.restrictedIpAddressMaps[i] = new HashMap();
        }
        ExpirationThread thread = new ExpirationThread(this.restrictedIpAddressMaps, this.failureTimeout);
        thread.setDaemon(true);
        thread.start();
    }

    protected final class ExpirationThread
    extends Thread {
        private Map[] restrictedIpAddressMaps;
        private int failureTimeout;

        public ExpirationThread(Map[] restrictedIpAddressMaps, int failureTimeout) {
            this.restrictedIpAddressMaps = restrictedIpAddressMaps;
            this.failureTimeout = failureTimeout;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.failureTimeout * 60);
                        this.cleanUpFailures();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUpFailures() {
            int length = this.restrictedIpAddressMaps.length;
            for (int i = 0; i < length; ++i) {
                Map map;
                Map map2 = map = this.restrictedIpAddressMaps[i];
                synchronized (map2) {
                    Set keys = map.keySet();
                    Iterator iter = keys.iterator();
                    while (iter.hasNext()) {
                        Object key = iter.next();
                        BigInteger integer = (BigInteger)map.get(key);
                        BigInteger newValue = integer.subtract(ONE);
                        System.out.println("For key: " + key + " new value is: " + newValue.toString());
                        if (newValue.equals(BigInteger.ZERO)) {
                            map.remove(key);
                            continue;
                        }
                        map.put(key, newValue);
                    }
                    continue;
                }
            }
        }
    }
}

