/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class WebUtils {
    private WebUtils() {
    }

    public static String getRequestParameterAsString(HttpServletRequest request, String parameter) {
        return request.getParameter(parameter);
    }

    public static boolean getRequestParameterAsBoolean(HttpServletRequest request, String parameter) {
        return request.getParameter(parameter) != null;
    }

    public static String stripJsessionFromUrl(String url) {
        if (url == null) {
            return null;
        }
        int jsessionPosition = url.indexOf(";jsession");
        if (jsessionPosition == -1) {
            return url;
        }
        int questionMarkPosition = url.indexOf("?");
        if (questionMarkPosition < jsessionPosition) {
            return url.substring(0, url.indexOf(";jsession"));
        }
        return url.substring(0, jsessionPosition) + url.substring(questionMarkPosition);
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie cookie = org.springframework.web.util.WebUtils.getCookie((HttpServletRequest)request, (String)cookieName);
        return cookie == null ? null : cookie.getValue();
    }
}

