/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class PropertiesHandler {
    public static String getPropertyValue(String name, Map m) {
        return Prop.getPropertyValueToApply(name, m, null);
    }

    public static String getPropertyValueLogDebug(String name, Map m, AbstractSession session) {
        return Prop.getPropertyValueToApply(name, m, session);
    }

    public static String getPrefixedPropertyValue(String prefix, String suffix, Map m) {
        return (String)PropertiesHandler.getPrefixValues(prefix, m).get(suffix);
    }

    public static Map getPrefixValues(String prefix, Map m) {
        return Prop.getPrefixValuesToApply(prefix, m, null);
    }

    public static Map getPrefixValuesLogDebug(String prefix, Map m, AbstractSession session) {
        return Prop.getPrefixValuesToApply(prefix, m, session);
    }

    public static String getDefaultPropertyValue(String name) {
        return Prop.getDefaultPropertyValueToApply(name, null);
    }

    public static String getDefaultPropertyValueLogDebug(String name, AbstractSession session) {
        return Prop.getDefaultPropertyValueToApply(name, session);
    }

    protected static boolean shouldUseDefault(String value) {
        return value != null && value.length() == 0;
    }

    protected static class DescriptorCustomizerProp
    extends Prop {
        DescriptorCustomizerProp() {
            super("toplink.descriptor.customizer.");
        }
    }

    protected static class CacheSharedProp
    extends Prop {
        CacheSharedProp() {
            super("toplink.cache.shared.", "false");
            this.valueArray = new Object[]{"true", "false"};
        }
    }

    protected static class CacheTypeProp
    extends Prop {
        CacheTypeProp() {
            super("toplink.cache.type.", "SoftWeak");
            String pcg = "oracle.toplink.essentials.internal.identitymaps.";
            this.valueArray = new Object[][]{{"Weak", pcg + "WeakIdentityMap"}, {"SoftWeak", pcg + "SoftCacheWeakIdentityMap"}, {"HardWeak", pcg + "HardCacheWeakIdentityMap"}, {"Full", pcg + "FullIdentityMap"}, {"NONE", pcg + "NoIdentityMap"}};
        }
    }

    protected static class CacheSizeProp
    extends Prop {
        CacheSizeProp() {
            super("toplink.cache.size.", Integer.toString(1000));
        }
    }

    protected static class TargetServerProp
    extends Prop {
        TargetServerProp() {
            super("toplink.target-server", "None");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "oracle.toplink.essentials.platform.server.";
            this.valueArray = new Object[][]{{"None", pcg + "NoServerPlatform"}, {"OC4J_10_1_3", pcg + "oc4j.Oc4jPlatform"}, {"SunAS9", pcg + "sunas.SunAS9ServerPlatform"}};
        }
    }

    protected static class TargetDatabaseProp
    extends Prop {
        TargetDatabaseProp() {
            super("toplink.target-database", "Auto");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "oracle.toplink.essentials.platform.database.";
            this.valueArray = new Object[][]{{"Auto", pcg + "DatabasePlatform"}, {"Oracle", pcg + "oracle.OraclePlatform"}, {"Attunity", pcg + "AttunityPlatform"}, {"Cloudscape", pcg + "CloudscapePlatform"}, {"Database", pcg + "DatabasePlatform"}, {"DB2Mainframe", pcg + "DB2MainframePlatform"}, {"DB2", pcg + "DB2Platform"}, {"DBase", pcg + "DBasePlatform"}, {"Derby", pcg + "DerbyPlatform"}, {"HSQL", pcg + "HSQLPlatform"}, {"Informix", pcg + "InformixPlatform"}, {"JavaDB", pcg + "JavaDBPlatform"}, {"MySQL4", pcg + "MySQL4Platform"}, {"PointBase", pcg + "PointBasePlatform"}, {"PostgreSQL", pcg + "PostgreSQLPlatform"}, {"SQLAnyWhere", pcg + "SQLAnyWherePlatform"}, {"SQLServer", pcg + "SQLServerPlatform"}, {"Sybase", pcg + "SybasePlatform"}, {"TimesTen", pcg + "TimesTenPlatform"}};
        }
    }

    protected static class LoggingLevelProp
    extends Prop {
        LoggingLevelProp() {
            super("toplink.logging.level", Level.CONFIG.getName());
            this.valueArray = new Object[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.OFF.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()};
        }
    }

    protected static abstract class Prop {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        String defaultValueToApply;
        boolean valueToApplyMayBeNull;
        boolean shouldReturnOriginalValueIfValueToApplyNotFound;

        Prop(String name) {
            this.name = name;
        }

        Prop(String name, String defaultValue) {
            this(name);
            this.defaultValue = defaultValue;
        }

        static String getPropertyValueFromMap(String name, Map m) {
            String value = (String)m.get(name);
            return value == null ? System.getProperty(name) : value;
        }

        static Map getPrefixValuesFromMap(String name, Map m) {
            String entityName;
            String str;
            HashMap<String, Object> mapOut = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                str = (String)entry.getKey();
                if (!str.startsWith(name)) continue;
                entityName = str.substring(name.length(), str.length());
                mapOut.put(entityName, entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : m.entrySet()) {
                str = (String)entry.getKey();
                if (!str.startsWith(name)) continue;
                entityName = str.substring(name.length(), str.length());
                mapOut.put(entityName, entry.getValue());
            }
            return mapOut;
        }

        static String getPropertyValue(String name, boolean shouldUseDefault, Map m, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                return null;
            }
            String value = Prop.getPropertyValueFromMap(name, m);
            if (value == null) {
                return null;
            }
            return prop.getValueToApply(value, shouldUseDefault, session);
        }

        static String getPropertyValueToApply(String name, Map m, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                return null;
            }
            String value = Prop.getPropertyValueFromMap(name, m);
            if (value == null) {
                return null;
            }
            return prop.getValueToApply(value, PropertiesHandler.shouldUseDefault(value), session);
        }

        static Map getPrefixValuesToApply(String prefix, Map m, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(prefix);
            if (prop == null) {
                return new HashMap(0);
            }
            Map mapIn = Prop.getPrefixValuesFromMap(prefix, m);
            if (mapIn.isEmpty()) {
                return mapIn;
            }
            HashMap<String, String> mapOut = new HashMap<String, String>(mapIn.size());
            for (Map.Entry entry : mapIn.entrySet()) {
                String suffix = (String)entry.getKey();
                String value = (String)entry.getValue();
                mapOut.put(suffix, prop.getValueToApply(value, PropertiesHandler.shouldUseDefault(value), suffix, session));
            }
            return mapOut;
        }

        static String getDefaultPropertyValueToApply(String name, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-default-for-unknown-property", new Object[]{name}));
            }
            prop.logDefault(session);
            return prop.defaultValueToApply;
        }

        String getValueToApply(String value, boolean shouldUseDefault, AbstractSession session) {
            return this.getValueToApply(value, shouldUseDefault, null, session);
        }

        String getValueToApply(String value, boolean shouldUseDefault, String suffix, AbstractSession session) {
            String key;
            if (shouldUseDefault) {
                this.logDefault(session, suffix);
                return this.defaultValueToApply;
            }
            String valueToApply = value;
            if (this.valueMap != null && (valueToApply = (String)this.valueMap.get(key = Prop.getUpperCaseString(value))) == null) {
                boolean notFound = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl = notFound = !this.valueMap.containsKey(key);
                }
                if (notFound) {
                    if (this.shouldReturnOriginalValueIfValueToApplyNotFound) {
                        valueToApply = value;
                    } else {
                        String propertyName = this.name;
                        if (suffix != null) {
                            propertyName = propertyName + suffix;
                        }
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-illegal-property-value", new Object[]{propertyName, Prop.getPrintValue(value)}));
                    }
                }
            }
            this.log(session, value, valueToApply, suffix);
            return valueToApply;
        }

        static String getUpperCaseString(String value) {
            if (value != null) {
                return value.toUpperCase();
            }
            return null;
        }

        static String getPrintValue(String value) {
            if (value != null) {
                return value;
            }
            return "null";
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] valueArray2 = (Object[][])this.valueArray;
                    for (int i = 0; i < valueArray2.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)valueArray2[i][0]), valueArray2[i][1]);
                        if (valueArray2[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = (String)this.valueMap.get(Prop.getUpperCaseString(this.defaultValue));
            } else {
                this.defaultValueToApply = this.defaultValue;
            }
        }

        void logDefault(AbstractSession session) {
            this.logDefault(session, null);
        }

        void logDefault(AbstractSession session, String suffix) {
            if (session != null) {
                String propertyName = this.name;
                if (suffix != null) {
                    propertyName = propertyName + suffix;
                }
                if (this.defaultValue != this.defaultValueToApply) {
                    session.log(1, "properties", "handler_property_value_default", new Object[]{propertyName, this.defaultValue, this.defaultValueToApply});
                } else {
                    session.log(1, "properties", "property_value_default", new Object[]{propertyName, this.defaultValue});
                }
            }
        }

        void log(AbstractSession session, String value, String valueToApply, String suffix) {
            if (session != null) {
                String propertyName = this.name;
                if (suffix != null) {
                    propertyName = propertyName + suffix;
                }
                if (value != valueToApply) {
                    session.log(1, "properties", "handler_property_value_specified", new Object[]{propertyName, value, valueToApply});
                } else {
                    session.log(1, "properties", "property_value_specified", new Object[]{propertyName, value});
                }
            }
        }

        static void addProp(Prop prop) {
            prop.initialize();
            mainMap.put(prop.name, prop);
        }

        static {
            Prop.addProp(new LoggingLevelProp());
            Prop.addProp(new TargetDatabaseProp());
            Prop.addProp(new TargetServerProp());
            Prop.addProp(new CacheSizeProp());
            Prop.addProp(new CacheTypeProp());
            Prop.addProp(new CacheSharedProp());
            Prop.addProp(new DescriptorCustomizerProp());
        }
    }
}

