/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.EJBQueryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataField;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataMethod;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataGeneratedValue;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataTableGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLEntityClassListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLValidator;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.queryframework.ColumnResult;
import oracle.toplink.essentials.queryframework.EJBQLPlaceHolderQuery;
import oracle.toplink.essentials.queryframework.EntityResult;
import oracle.toplink.essentials.queryframework.FieldResult;
import oracle.toplink.essentials.queryframework.SQLResultSetMapping;
import oracle.toplink.essentials.sessions.Session;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMappingsXMLProcessor
extends MetadataProcessor {
    protected String m_persistenceUnitAccess = "";
    protected String m_persistenceUnitSchema = "";
    protected String m_persistenceUnitCatalog = "";
    protected String m_entityMappingsAccess;
    protected String m_entityMappingsSchema;
    protected String m_entityMappingsCatalog;
    private XMLHelper m_helper;
    private HashMap m_namedQueries;
    private HashMap m_namedNativeQueries;

    public EntityMappingsXMLProcessor(boolean enableLazyForOneToOne) {
        this.m_enableLazyForOneToOne = enableLazyForOneToOne;
        this.m_namedQueries = new HashMap();
        this.m_namedNativeQueries = new HashMap();
        this.m_validator = new XMLValidator();
        this.m_metadataProject = new MetadataProject();
    }

    protected void addEventMethodNameToListener(XMLListener listener, Node node, String eventTag) {
        Node result = this.m_helper.getNode(node, eventTag);
        if (result != null) {
            listener.addEventMethodName(eventTag, this.m_helper.getNodeValue(result, "@method-name"));
        }
    }

    protected void addEventMethodNameToMap(HashMap methodMap, Node node, String eventTag) {
        Node result = this.m_helper.getNode(node, eventTag);
        if (result != null) {
            methodMap.put(eventTag, this.m_helper.getNodeValue(result, "@method-name"));
        }
    }

    public void addNamedQueriesToSession(Session session) {
        HashMap hints;
        String queryString;
        HashMap props;
        for (String queryName : this.m_namedQueries.keySet()) {
            if (session.getQuery(queryName) != null) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName);
                continue;
            }
            try {
                props = (HashMap)this.m_namedQueries.get(queryName);
                queryString = (String)props.get("query");
                hints = (HashMap)props.get("hint");
                session.addEjbqlPlaceHolderQuery(new EJBQLPlaceHolderQuery(queryName, queryString, hints));
            }
            catch (Exception exception) {
                this.getValidator().throwErrorProcessingNamedQueryElement(queryName, exception);
            }
        }
        for (String queryName : this.m_namedNativeQueries.keySet()) {
            if (session.getQuery(queryName) != null) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName);
                continue;
            }
            try {
                Class resultClass;
                props = (HashMap)this.m_namedNativeQueries.get(queryName);
                queryString = (String)props.get("query");
                hints = (HashMap)props.get("hint");
                if (props.containsKey("@result-class") && (resultClass = MetadataHelper.getClassForName((String)props.get("@result-class"), this.m_loader)) != Void.TYPE) {
                    session.addQuery(queryName, EJBQueryImpl.buildSQLDatabaseQuery(resultClass, queryString, hints));
                    continue;
                }
                if (props.containsKey("@result-set-mapping")) {
                    session.addQuery(queryName, EJBQueryImpl.buildSQLDatabaseQuery((String)props.get("@result-set-mapping"), queryString, hints));
                    continue;
                }
                session.addQuery(queryName, EJBQueryImpl.buildSQLDatabaseQuery(queryString, hints));
            }
            catch (Exception exception) {
                this.getValidator().throwErrorProcessingNamedQueryElement(queryName, exception);
            }
        }
    }

    public static Set buildClassSet(InputStream xmlDocumentInputStream, String fileName, ClassLoader loader) {
        XMLHelper helper = new XMLHelper(xmlDocumentInputStream, fileName, loader);
        String defaultPkg = helper.getNodeValue(new String[]{"entity-mappings", "package", "text()"});
        HashSet classSet = new HashSet();
        classSet.addAll(EntityMappingsXMLProcessor.buildClassSetForNodeList(helper, "entity", defaultPkg));
        classSet.addAll(EntityMappingsXMLProcessor.buildClassSetForNodeList(helper, "embeddable", defaultPkg));
        return classSet;
    }

    protected static Set buildClassSetForNodeList(XMLHelper helper, String xPath, String defaultPkg) {
        HashSet<String> classNameSet = new HashSet<String>();
        NodeList nodes = helper.getNodes("entity-mappings", xPath);
        int nodeCount = nodes.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            classNameSet.add(XMLHelper.getFullyQualifiedClassName(helper.getNode(nodes.item(i), "@class").getNodeValue(), defaultPkg));
        }
        return classNameSet;
    }

    protected XMLAccessor createAccessor(Node attributeNode, boolean usePropertyAccess, XMLDescriptor descriptor) {
        Class entityClass = descriptor.getJavaClass();
        String attributeName = this.m_helper.getNodeValue(attributeNode, "@name");
        if (usePropertyAccess) {
            Method method = MetadataHelper.getMethodForPropertyName(attributeName, entityClass);
            if (method == null) {
                throw ValidationException.unableToDetermineClassForProperty(attributeName, entityClass);
            }
            return new XMLAccessor(new MetadataMethod(method), this, descriptor, attributeNode);
        }
        Field field = MetadataHelper.getFieldForName(attributeName, entityClass);
        if (field == null) {
            throw ValidationException.unableToDetermineClassForField(attributeName, entityClass);
        }
        return new XMLAccessor(new MetadataField(field), this, descriptor, attributeNode);
    }

    protected SQLResultSetMapping createSQLResultSetMapping(Node node) {
        NodeList columnResultList;
        SQLResultSetMapping mapping = new SQLResultSetMapping(this.m_helper.getNodeValue(node, "@name"));
        NodeList entityResultNodes = this.m_helper.getNodes(node, "entity-result");
        if (entityResultNodes != null) {
            int nodeCount = entityResultNodes.getLength();
            for (int j = 0; j < nodeCount; ++j) {
                NodeList fieldResultNodes;
                Node erNode = entityResultNodes.item(j);
                Node result = this.m_helper.getNode(erNode, "@entity-class");
                Class entityClass = MetadataHelper.getClassForName(result.getNodeValue(), this.m_loader);
                EntityResult eResult = new EntityResult(entityClass.getName());
                result = this.m_helper.getNode(erNode, "@discriminator-column");
                if (result != null) {
                    eResult.setDiscriminatorColumn(result.getNodeValue());
                }
                if ((fieldResultNodes = this.m_helper.getNodes(erNode, "field-result")) != null) {
                    int fieldCount = fieldResultNodes.getLength();
                    for (int k = 0; k < fieldCount; ++k) {
                        Node frNode = fieldResultNodes.item(k);
                        String name = this.m_helper.getNodeValue(frNode, "@name");
                        String column = this.m_helper.getNodeValue(frNode, "@column");
                        eResult.addFieldResult(new FieldResult(name, column));
                    }
                }
                mapping.addResult(eResult);
            }
        }
        if ((columnResultList = this.m_helper.getNodes(node, "column-result")) != null) {
            int columnCount = columnResultList.getLength();
            for (int j = 0; j < columnCount; ++j) {
                mapping.addResult(new ColumnResult(this.m_helper.getNodeValue(columnResultList.item(j), "@name")));
            }
        }
        return mapping;
    }

    @Override
    public XMLDescriptor getMetadataDescriptor(Class cls) {
        XMLDescriptor dmd = (XMLDescriptor)this.getDescriptorMetadataMap().get(cls);
        if (dmd == null) {
            ClassDescriptor descriptorOnProject = MetadataHelper.findDescriptor(this.m_session.getProject(), cls);
            if (descriptorOnProject != null) {
                dmd = new XMLDescriptor(descriptorOnProject, cls, this.m_helper);
            } else {
                dmd = new XMLDescriptor(cls, this.m_helper);
                this.m_session.getProject().addDescriptor(dmd.getDescriptor());
            }
            this.getDescriptorMetadataMap().put(cls, dmd);
        } else {
            dmd.setHelper(this.m_helper);
        }
        return dmd;
    }

    public HashMap getDescriptorMetadataMap() {
        if (this.m_metadataDescriptors == null) {
            this.m_metadataDescriptors = new HashMap();
        }
        return this.m_metadataDescriptors;
    }

    protected Object[] getCascadeTypes(XMLAccessor accessor) {
        HashSet<String> cascadeVals = new HashSet<String>();
        if (accessor.hasCascade()) {
            NodeList cascadeNodes = accessor.getCascade();
            int nodeCount = cascadeNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                cascadeVals.add(cascadeNodes.item(i).getLocalName());
            }
        }
        return cascadeVals.toArray();
    }

    protected String getFieldName(String candidateName, String defaultName, String context, Class javaClass) {
        if (candidateName != null && !candidateName.equals("")) {
            return candidateName;
        }
        this.getLogger().logConfigMessage(context, javaClass, (Object)defaultName);
        return defaultName;
    }

    protected XMLHelper getHelper() {
        return this.m_helper;
    }

    @Override
    public XMLLogger getLogger() {
        return (XMLLogger)this.m_logger;
    }

    protected List getPrimaryKeyFields(XMLDescriptor dmd) {
        List primaryKeyFields = dmd.getPrimaryKeyFields();
        if (primaryKeyFields.isEmpty() && dmd.isInheritanceSubclass()) {
            primaryKeyFields = this.getMetadataDescriptor(this.m_helper.locateRootEntity(dmd.getJavaClass())).getPrimaryKeyFields();
        }
        return primaryKeyFields;
    }

    protected Object[] getPrimaryKeyJoinColumns(Node node) {
        Object[] pkJoinCols = new Object[]{};
        NodeList primaryKeyJoinColumns = this.m_helper.getNodes(node, "primary-key-join-column");
        if (primaryKeyJoinColumns != null) {
            pkJoinCols = new Object[primaryKeyJoinColumns.getLength()];
            int columnCount = primaryKeyJoinColumns.getLength();
            for (int i = 0; i < columnCount; ++i) {
                pkJoinCols[i] = primaryKeyJoinColumns.item(i);
            }
        }
        return pkJoinCols;
    }

    protected DatabaseTable getRelationTable(XMLAccessor accessor) {
        Node joinTableNode = accessor.getJoinTableNode();
        if (joinTableNode != null) {
            XMLDescriptor xmlDmd = accessor.getMetadataDescriptor();
            String tableName = this.m_helper.getNodeValue(joinTableNode, "@name");
            String schemaName = this.m_helper.getNodeValue(joinTableNode, "@schema", xmlDmd.getSchema());
            String catalogName = this.m_helper.getNodeValue(joinTableNode, "@catalog", xmlDmd.getCatalog());
            DatabaseTable dbTable = this.buildJoinTable(tableName, catalogName, schemaName, accessor);
            this.processUniqueConstraints(joinTableNode, dbTable);
            return dbTable;
        }
        return this.buildDefaultJoinTable(accessor);
    }

    protected void init(AbstractSession session, InputStream xmlDocumentStream, String fileName) {
        this.m_session = session;
        this.m_logger = new XMLLogger(session);
        this.m_relatedEntities = new HashSet();
        this.m_helper = new XMLHelper(xmlDocumentStream, fileName, this.m_loader);
    }

    @Override
    public XMLValidator getValidator() {
        return (XMLValidator)this.m_validator;
    }

    @Override
    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataAccessor accessor, String defaultName, String context) {
        XMLDescriptor referenceMd;
        XMLDescriptor md;
        if (context.equals("metadata_default_source_pk_column") || context.equals("metadata_default_source_fk_column")) {
            md = (XMLDescriptor)accessor.getMetadataDescriptor();
            referenceMd = (XMLDescriptor)accessor.getReferenceMetadataDescriptor();
        } else {
            md = (XMLDescriptor)accessor.getReferenceMetadataDescriptor();
            referenceMd = (XMLDescriptor)accessor.getMetadataDescriptor();
        }
        if (defaultName.equals(md.getPrimaryKeyFieldName())) {
            md.handleDefaultPrimaryKeyUsage(dbField);
        } else if (defaultName.equals(referenceMd.getPrimaryKeyFieldName())) {
            referenceMd.handleDefaultPrimaryKeyUsage(dbField);
        } else {
            referenceMd.handleComplexDefaultPrimaryKeyUsage(dbField);
        }
    }

    @Override
    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataDescriptor md) {
        ((XMLDescriptor)md).handleDefaultPrimaryKeyUsage(dbField);
    }

    @Override
    protected boolean handlePotentialPartialOneToOneRelationshipMapping(OneToOneMapping mapping, List joinColumns) {
        if (mapping.requiresCompletion()) {
            if (joinColumns.size() == 1) {
                MetadataJoinColumn mjc = (MetadataJoinColumn)joinColumns.get(0);
                if (mjc.getForeignKeyField().getName().equals("")) {
                    mapping.setXMLPKNameAttribute(mjc.getPrimaryKeyField().getName());
                    return true;
                }
                if (mjc.getPrimaryKeyField().getName().equals("")) {
                    mapping.setXMLFKNameAttribute(mjc.getForeignKeyField().getName());
                    return true;
                }
            }
            mapping.setRequiresCompletion(false);
        }
        return false;
    }

    @Override
    protected boolean handlePotentialPartialManyToManyRelationshipMapping(ManyToManyMapping mapping, boolean isSource, List relationKeys) {
        if (!isSource && mapping.requiresCompletion()) {
            if (relationKeys.size() == 1) {
                MetadataJoinColumn mjc = (MetadataJoinColumn)relationKeys.get(0);
                if (mjc.getForeignKeyField().getName().equals("")) {
                    mapping.setXMLPKNameAttribute(mjc.getPrimaryKeyField().getName());
                    return true;
                }
                if (mjc.getPrimaryKeyField().getName().equals("")) {
                    mapping.setXMLFKNameAttribute(mjc.getForeignKeyField().getName());
                    return true;
                }
            }
            mapping.setRequiresCompletion(false);
        }
        return false;
    }

    protected boolean hasPrimaryKeyJoinColumn(Node node) {
        return this.m_helper.getNodes(node, "primary-key-join-column").getLength() > 0;
    }

    @Override
    protected void processAccessors(Class cls, boolean usePropertyAccess, MetadataDescriptor descriptor) {
        Node classNode = this.m_helper.locateNode(cls);
        if (classNode != null) {
            this.processAttributes(classNode, usePropertyAccess, (XMLDescriptor)descriptor);
        }
    }

    @Override
    protected void processAssociationOverrides(AggregateObjectMapping mapping, MetadataAccessor accessor) {
    }

    @Override
    protected void processAssociationOverrides(Class cls, MetadataDescriptor descriptor) {
        NodeList nodes;
        Node classNode = this.m_helper.locateNode(cls);
        if (classNode != null && (nodes = this.m_helper.getNodes(classNode, "association-override")) != null) {
            int nodeCount = nodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node overrideNode = nodes.item(i);
                String name = this.m_helper.getNodeValue(overrideNode, "@name");
                NodeList jCols = this.m_helper.getNodes(overrideNode, "join-column");
                if (jCols == null || jCols.getLength() <= 0) continue;
                descriptor.addAssociationOverride(name, new Object[]{jCols});
            }
        }
        super.processAssociationOverrides(cls, descriptor);
    }

    @Override
    protected void processAttributeOverrides(AggregateObjectMapping mapping, MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        NodeList overrideNodes = accessor.getAttributeOverrideNodes();
        if (overrideNodes != null) {
            int overrideCount = overrideNodes.getLength();
            for (int i = 0; i < overrideCount; ++i) {
                Node overrideNode = overrideNodes.item(i);
                String attributeName = this.m_helper.getNodeValue(overrideNode, "@name");
                Node columnNode = this.m_helper.getNode(overrideNode, "column");
                MetadataColumn column = this.processColumn(columnNode, attributeName, accessor.getMetadataDescriptor(), accessor.getAnnotatedElement());
                this.processAttributeOverride(mapping, column, accessor);
            }
        }
    }

    @Override
    protected void processAttributeOverrides(Class cls, MetadataDescriptor descriptor) {
        NodeList nodes;
        Node classNode = this.m_helper.locateNode(cls);
        if (classNode != null && (nodes = this.m_helper.getNodes(classNode, "attribute-override")) != null) {
            int nodeCount = nodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node node = nodes.item(i);
                String attributeName = this.m_helper.getNodeValue(node, "@name");
                Node columnNode = this.m_helper.getNode(node, "column");
                MetadataColumn column = this.processColumn(columnNode, attributeName, descriptor, descriptor.getJavaClass());
                descriptor.addAttributeOverride(column);
            }
        }
        super.processAttributeOverrides(cls, descriptor);
    }

    protected void processAttributes(Node node, boolean usePropertyAccess, XMLDescriptor descriptor) {
        NodeList attributeNodes = this.m_helper.getNodes(node, "attributes", "child::*");
        if (attributeNodes != null) {
            int nodeCount = attributeNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                this.processAccessor(this.createAccessor(attributeNodes.item(i), usePropertyAccess, descriptor));
            }
        }
        descriptor.setIsProcessed(true);
    }

    @Override
    protected void processBasic(DirectToFieldMapping mapping, MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.isBasic()) {
            if (accessor.usesIndirection()) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_basic_fetch_lazy", accessor);
            }
            mapping.setIsOptional(accessor.isOptional());
        }
    }

    @Override
    protected void processCascadeType(ForeignReferenceMapping mapping, MetadataAccessor accessor) {
        Object[] cTypes = accessor.getCascadeTypes();
        for (int i = 0; i < cTypes.length; ++i) {
            this.setCascadeType((String)cTypes[i], mapping);
        }
        if (accessor.getMetadataDescriptor().isCascadePersistSet().booleanValue() && !mapping.isCascadePersist()) {
            this.setCascadeType("cascade-persist", mapping);
        }
    }

    @Override
    protected MetadataColumn processColumn(MetadataAccessor accessor) {
        return this.processColumn(((XMLAccessor)accessor).getColumnNode(), accessor.getAttributeName(), accessor.getMetadataDescriptor(), accessor.getAnnotatedElement());
    }

    protected MetadataColumn processColumn(Node columnNode, String attributeName, MetadataDescriptor descriptor, AnnotatedElement element) {
        MetadataColumn column = new MetadataColumn(attributeName, descriptor.getPrimaryTableName(), element);
        if (columnNode != null) {
            column.setName(this.m_helper.getNodeValue(columnNode, "@name", ""));
            column.setTable(this.m_helper.getNodeValue(columnNode, "@table", ""));
            column.setInsertable(this.m_helper.getNodeValue(columnNode, "@insertable", true));
            column.setUpdatable(this.m_helper.getNodeValue(columnNode, "@updatable", true));
            column.setUnique(this.m_helper.getNodeValue(columnNode, "@unique", false));
            column.setNullable(this.m_helper.getNodeValue(columnNode, "@nullable", true));
            column.setColumnDefinition(this.m_helper.getNodeValue(columnNode, "@column-definition", ""));
            column.setLength(this.m_helper.getNodeValue(columnNode, "@length", 255));
            column.setPrecision(this.m_helper.getNodeValue(columnNode, "@precision", 0));
            column.setScale(this.m_helper.getNodeValue(columnNode, "@scale", 0));
        }
        this.processColumnDefaults(column);
        return column;
    }

    protected void processDefaultId(MetadataDescriptor metadataDescriptor) {
        metadataDescriptor.setDefaultPrimaryKey();
        DatabaseField pkField = new DatabaseField();
        pkField.setTableName(metadataDescriptor.getPrimaryTableName());
        pkField.setName("TOPLINKDEFAULTID");
        metadataDescriptor.addPrimaryKeyField(pkField);
    }

    protected void processDefaultListeners(List<String> defaultListeners, HashMap<String, Node> defaultListenerEventMethods, XMLDescriptor descriptor) {
        String entityClassName = descriptor.getJavaClassName();
        for (String defaultListener : defaultListeners) {
            XMLEntityListener listener = new XMLEntityListener(defaultListener, entityClassName);
            listener.getEventMethodNames().putAll((HashMap)((Object)defaultListenerEventMethods.get(defaultListener)));
            descriptor.addDefaultEventListener(listener);
        }
    }

    protected void processDiscriminatorColumn(Node entityNode, XMLDescriptor descriptor) {
        int length = 31;
        String columnName = "";
        String columnDefinition = "";
        String discriminatorType = "STRING";
        Node result = this.m_helper.getNode(entityNode, "discriminator-column");
        if (result != null) {
            discriminatorType = this.m_helper.getNodeValue(result, "@discriminator-type", discriminatorType);
            columnName = this.m_helper.getNodeValue(result, "@name");
            columnDefinition = this.m_helper.getNodeValue(result, "@column-definition");
            length = this.m_helper.getNodeValue(result, "@length", length);
        }
        this.processDiscriminatorColumn(columnName, columnDefinition, length, discriminatorType, descriptor);
    }

    @Override
    protected void processEnumerated(DirectToFieldMapping mapping, MetadataAccessor accessor) {
        Node enumeratedNode = ((XMLAccessor)accessor).getEnumeratedNode();
        boolean isOrdinal = true;
        String enumeratedType = enumeratedNode.getNodeValue();
        if (enumeratedType != null && !enumeratedType.equals("")) {
            isOrdinal = enumeratedType.equals("ORDINAL");
        }
        this.processEnumerated(mapping, isOrdinal, accessor);
    }

    protected void processEntities() {
        NodeList entityNodes = this.m_helper.getNodes("entity-mappings", "entity");
        if (entityNodes != null) {
            int count = entityNodes.getLength();
            for (int i = 0; i < count; ++i) {
                this.processEntityNode(entityNodes.item(i));
            }
        }
    }

    @Override
    protected void processEntityClass(Class cls) {
        this.processEntityNode(this.m_helper.locateEntityNode(cls));
    }

    protected void processEntityNode(Node node) {
        Class entityClass = this.m_helper.getClassForNode(node);
        XMLDescriptor descriptor = this.getMetadataDescriptor(entityClass);
        if (!descriptor.isProcessed()) {
            descriptor.setIgnoreFlags();
            this.processEntity(this.m_helper.getNodeValue(node, "@name"), descriptor);
            if (!descriptor.shouldIgnoreAnnotations()) {
                descriptor.setShouldIgnoreAnnotations(this.m_helper.getNodeValue(node, "@metadata-complete", false));
            }
            descriptor.setXmlAccess(this.m_helper.getNodeValue(node, "@access", this.m_entityMappingsAccess));
            descriptor.setSchema(this.m_entityMappingsSchema);
            descriptor.setCatalog(this.m_entityMappingsCatalog);
            this.processNamedQueries(this.m_helper.getNodes(node, "named-query"));
            this.processNamedNativeQueries(this.m_helper.getNodes(node, "named-native-query"));
            this.processSqlResultSetMappings(this.m_helper.getNodes(node, "sql-result-set-mapping"));
            this.processTableGenerator(this.m_helper.getNode(node, "table-generator"));
            this.processSequenceGenerator(this.m_helper.getNode(node, "sequence-generator"));
            this.processTable(node, descriptor);
            this.processIdClass(descriptor);
            this.processMappedSuperclasses(descriptor);
            this.processAttributes(node, descriptor.usesPropertyAccess(), descriptor);
            if (descriptor.hasCompositePrimaryKey()) {
                if (descriptor.pkClassWasNotValidated()) {
                    this.getValidator().throwInvalidCompositePKSpecification(entityClass, descriptor.getPKClassName());
                }
            } else if (!descriptor.hasPrimaryKeyFields() && !descriptor.isInheritanceSubclass()) {
                this.processDefaultId(descriptor);
            }
            this.processSecondaryTables(node, descriptor);
            this.processEntityListeners(node, descriptor);
        }
    }

    public Session processEntityMappings(AbstractSession session, InputStream xmlDocumentStream, String fileName) {
        this.init(session, xmlDocumentStream, fileName);
        this.m_entityMappingsAccess = this.m_helper.getNodeValue(new String[]{"entity-mappings", "access", "text()"}, this.m_persistenceUnitAccess);
        this.m_entityMappingsSchema = this.m_helper.getNodeValue(new String[]{"entity-mappings", "schema", "text()"}, this.m_persistenceUnitSchema);
        this.m_entityMappingsCatalog = this.m_helper.getNodeValue(new String[]{"entity-mappings", "catalog", "text()"}, this.m_persistenceUnitCatalog);
        this.processNamedQueries(this.m_helper.getNodes("entity-mappings", "named-query"));
        this.processNamedNativeQueries(this.m_helper.getNodes("entity-mappings", "named-native-query"));
        this.processSqlResultSetMappings(this.m_helper.getNodes("entity-mappings", "sql-result-set-mapping"));
        this.processTableGenerators();
        this.processSequenceGenerators();
        this.processEntities();
        for (XMLDescriptor descriptor : this.m_relatedEntities) {
            this.processRelatedEntity(descriptor);
        }
        return session;
    }

    protected void processRelatedEntity(XMLDescriptor descriptor) {
        if (descriptor.isInheritanceSubclass()) {
            this.processInheritanceSubclass(descriptor);
        }
        for (MetadataAccessor accessor : descriptor.getRelationshipAccessors()) {
            this.processRelationshipAccessor(accessor);
        }
    }

    protected void processEvents(XMLListener listener, Node node) {
        this.addEventMethodNameToListener(listener, node, "pre-persist");
        this.addEventMethodNameToListener(listener, node, "post-persist");
        this.addEventMethodNameToListener(listener, node, "pre-remove");
        this.addEventMethodNameToListener(listener, node, "post-remove");
        this.addEventMethodNameToListener(listener, node, "pre-update");
        this.addEventMethodNameToListener(listener, node, "post-update");
        this.addEventMethodNameToListener(listener, node, "post-load");
    }

    @Override
    protected void processGeneratedValue(Object generatedValueNode, DatabaseField field, MetadataDescriptor descriptor) {
        MetadataGeneratedValue generatedValue = new MetadataGeneratedValue();
        generatedValue.setStrategy(this.m_helper.getNodeValue((Node)generatedValueNode, "@strategy"));
        generatedValue.setGenerator(this.m_helper.getNodeValue((Node)generatedValueNode, "@generator", "AUTO"));
        this.processGeneratedValue(generatedValue, field, descriptor);
    }

    protected void processEventMethodNames(HashMap methodMap, Node node) {
        this.addEventMethodNameToMap(methodMap, node, "pre-persist");
        this.addEventMethodNameToMap(methodMap, node, "post-persist");
        this.addEventMethodNameToMap(methodMap, node, "pre-remove");
        this.addEventMethodNameToMap(methodMap, node, "post-remove");
        this.addEventMethodNameToMap(methodMap, node, "pre-update");
        this.addEventMethodNameToMap(methodMap, node, "post-update");
        this.addEventMethodNameToMap(methodMap, node, "post-load");
    }

    @Override
    protected void processId(DatabaseField field, MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (accessor.isId()) {
            this.processId(field, accessor.getGeneratedValueNode(), accessor);
        }
    }

    protected void processIdClass(XMLDescriptor descriptor) {
        Class cls = descriptor.getJavaClass();
        Node node = this.m_helper.locateEntityNode(cls);
        Node result = this.m_helper.getNode(node, "id-class");
        if (result != null) {
            this.processIdClass(this.m_helper.getClassForNode(result), descriptor);
        }
    }

    @Override
    protected void processInheritanceRoot(MetadataDescriptor metadataDescriptor) {
        XMLDescriptor descriptor = (XMLDescriptor)metadataDescriptor;
        Node entityNode = this.m_helper.locateEntityNode(descriptor.getJavaClass());
        if (descriptor.ignoreInheritanceAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_INHERITANCE, descriptor);
        } else {
            Node inheritanceNode = this.m_helper.getNode(entityNode, "inheritance");
            if (inheritanceNode != null || descriptor.isInheritanceRoot()) {
                String strategy = "SINGLE_TABLE";
                if (inheritanceNode != null) {
                    Node rootResult = this.m_helper.getNode(inheritanceNode, "@strategy");
                    strategy = rootResult.getNodeValue();
                }
                descriptor.setInheritanceStrategy(strategy);
                this.processDiscriminatorColumn(entityNode, descriptor);
                this.processDiscriminatorValue(descriptor);
            }
        }
    }

    protected MetadataJoinColumn processJoinColumn(Node joinColumn, XMLAccessor accessor, String targetTable, MetadataDescriptor sourceDmd) {
        String name = this.m_helper.getNodeValue(joinColumn, "@name");
        String referencedColumnName = this.m_helper.getNodeValue(joinColumn, "@referenced-column-name");
        boolean isUnique = this.m_helper.getNodeValue(joinColumn, "@unique", false);
        boolean isNullable = this.m_helper.getNodeValue(joinColumn, "@nullable", true);
        boolean isInsertable = this.m_helper.getNodeValue(joinColumn, "@insertable", true);
        boolean isUpdatable = this.m_helper.getNodeValue(joinColumn, "@updatable", true);
        String columnDefinition = this.m_helper.getNodeValue(joinColumn, "@column-definition");
        String tableName = this.m_helper.getNodeValue(joinColumn, "@secondary-table");
        return this.processJoinColumn(targetTable, name, referencedColumnName, columnDefinition, tableName, isUnique, isNullable, isInsertable, isUpdatable, accessor, sourceDmd);
    }

    @Override
    protected ArrayList processJoinColumns(MetadataAccessor metadataAccessor) {
        ArrayList<MetadataJoinColumn> allJoinColumns = new ArrayList<MetadataJoinColumn>();
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        XMLDescriptor dmd = accessor.getMetadataDescriptor();
        String targetTableName = dmd.getPrimaryTableName();
        MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
        String sourceTableName = referenceDmd.getPrimaryTableName();
        Node node = accessor.getAttributeNode();
        String attributeName = accessor.getAttributeName();
        NodeList joinColumns = dmd.hasAssociationOverrideFor(accessor) ? (NodeList)dmd.getAssociationOverrideFor(accessor)[0] : this.m_helper.getNodes(node, "join-column");
        if (referenceDmd.hasCompositePrimaryKey()) {
            if (joinColumns == null || joinColumns.getLength() != referenceDmd.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompleteJoinColumnsSpecified(dmd.getJavaClass(), attributeName);
            }
            int columnCount = joinColumns.getLength();
            for (int i = 0; i < columnCount; ++i) {
                allJoinColumns.add(this.processJoinColumn(joinColumns.item(i), accessor, targetTableName, referenceDmd));
            }
        } else if (joinColumns != null && joinColumns.getLength() != 0) {
            if (joinColumns.getLength() > 1) {
                this.getValidator().throwExcessiveJoinColumnsSpecified(dmd.getJavaClass(), attributeName);
            }
            allJoinColumns.add(this.processJoinColumn(joinColumns.item(0), accessor, targetTableName, referenceDmd));
        } else {
            this.addJoinColumnDefault(allJoinColumns, sourceTableName, targetTableName, dmd);
        }
        return allJoinColumns;
    }

    @Override
    protected void processJoinTable(ManyToManyMapping mapping, MetadataAccessor metadataAccessor) {
        XMLAccessor accessor = (XMLAccessor)metadataAccessor;
        if (!accessor.isTargetEntityDefinedInDocument()) {
            mapping.setRequiresCompletion(true);
        }
        DatabaseTable relationTable = this.getRelationTable(accessor);
        mapping.setRelationTable(relationTable);
        String relationTableName = relationTable.getQualifiedName();
        ArrayList<MetadataJoinColumn> sourceKeys = new ArrayList<MetadataJoinColumn>();
        ArrayList<MetadataJoinColumn> targetKeys = new ArrayList<MetadataJoinColumn>();
        Node joinTableNode = accessor.getJoinTableNode();
        if (joinTableNode != null) {
            int i;
            int columnCount;
            NodeList jCols = this.m_helper.getNodes(joinTableNode, "join-column");
            if (jCols != null) {
                columnCount = jCols.getLength();
                for (i = 0; i < columnCount; ++i) {
                    sourceKeys.add(this.processJoinColumn(jCols.item(i), accessor, relationTableName, accessor.getMetadataDescriptor()));
                }
            }
            if ((jCols = this.m_helper.getNodes(joinTableNode, "inverse-join-column")) != null) {
                columnCount = jCols.getLength();
                for (i = 0; i < columnCount; ++i) {
                    targetKeys.add(this.processJoinColumn(jCols.item(i), accessor, relationTableName, accessor.getReferenceMetadataDescriptor()));
                }
            }
        }
        this.processJoinTable(mapping, sourceKeys, targetKeys, accessor);
    }

    protected void processEntityListeners(Node node, XMLDescriptor xmlDmd) {
        xmlDmd.setExcludeSuperclassListeners(this.m_helper.hasNode(node, "exclude-superclass-listeners"));
        xmlDmd.setExcludeDefaultListeners(this.m_helper.hasNode(node, "exclude-default-listeners"));
        this.processEntityListeners(node, new String[]{"entity-listeners", "entity-listener"}, xmlDmd);
        this.processEntityEventListener(node, xmlDmd);
    }

    protected void processEntityListeners(Node node, String[] xPath, XMLDescriptor xmlDmd) {
        NodeList listenerNodes = this.m_helper.getNodes(node, xPath);
        if (listenerNodes.getLength() > 0) {
            int nodeCount = listenerNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node listenerNode = listenerNodes.item(i);
                String listenerClassName = this.m_helper.getClassNameForNode(listenerNode);
                XMLEntityListener listener = new XMLEntityListener(listenerClassName, xmlDmd.getJavaClassName());
                this.processEvents(listener, listenerNode);
                xmlDmd.addEntityListenerEventListener(listener);
            }
        }
    }

    protected void processEntityEventListener(Node node, XMLDescriptor descriptor) {
        if (this.m_helper.entityHasCallbackMethod(node)) {
            XMLEntityClassListener listener = new XMLEntityClassListener(descriptor.getJavaClassName());
            this.processEvents(listener, node);
            descriptor.setEntityEventListener(listener);
        }
    }

    @Override
    protected void processNamedNativeQueries(Class cls, MetadataDescriptor descriptor) {
        Node classNode = this.m_helper.locateNode(cls);
        if (classNode != null) {
            this.processNamedNativeQueries(this.m_helper.getNodes(classNode, "named-native-query"));
        }
    }

    protected void processNamedNativeQueries(NodeList queryNodes) {
        if (queryNodes != null) {
            int queryCount = queryNodes.getLength();
            for (int i = 0; i < queryCount; ++i) {
                String resultSetMapping;
                Node queryNode = queryNodes.item(i);
                String queryName = this.m_helper.getNodeValue(queryNode, "@name");
                if (this.m_namedNativeQueries.containsKey(queryName)) {
                    this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName);
                    continue;
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                String ejbql = this.m_helper.getNodeValue(queryNode, new String[]{"query", "text()"});
                properties.put("query", ejbql);
                String resultClass = this.m_helper.getNodeValue(queryNode, "@result-class");
                if (!resultClass.equals("")) {
                    properties.put("@result-class", this.m_helper.getFullyQualifiedClassName(resultClass));
                }
                if (!(resultSetMapping = this.m_helper.getNodeValue(queryNode, "@result-set-mapping")).equals("")) {
                    properties.put("@result-set-mapping", resultSetMapping);
                }
                properties.put("hint", this.processQueryHints(queryNode));
                this.m_namedNativeQueries.put(queryName, properties);
            }
        }
    }

    @Override
    protected void processNamedQueries(Class cls, MetadataDescriptor descriptor) {
        Node classNode = this.m_helper.locateNode(cls);
        if (classNode != null) {
            this.processNamedQueries(this.m_helper.getNodes(classNode, "named-query"));
        }
    }

    protected void processNamedQueries(NodeList queryNodes) {
        if (queryNodes != null) {
            int queryCount = queryNodes.getLength();
            for (int i = 0; i < queryCount; ++i) {
                Node queryNode = queryNodes.item(i);
                String queryName = this.m_helper.getNodeValue(queryNode, "@name");
                if (this.m_namedQueries.containsKey(queryName)) {
                    this.getLogger().logWarningMessage(MetadataLogger.IGNORE_QUERY, queryName);
                    continue;
                }
                String ejbql = this.m_helper.getNodeValue(queryNode, new String[]{"query", "text()"});
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("query", ejbql);
                properties.put("hint", this.processQueryHints(queryNode));
                this.m_namedQueries.put(queryName, properties);
            }
        }
    }

    @Override
    protected void processOwningMappingKeys(OneToOneMapping mapping, MetadataAccessor accessor) {
        if (!((XMLAccessor)accessor).isTargetEntityDefinedInDocument()) {
            mapping.setRequiresCompletion(true);
        }
        super.processOwningMappingKeys(mapping, accessor);
    }

    protected void processPersistenceUnitDefault(String key, Node contextNode, HashMap puDefaults) {
        Node node = this.m_helper.getNode(contextNode, new String[]{key, "text()"});
        if (node != null) {
            String nodeValue = node.getNodeValue();
            Object existingValue = puDefaults.get(key);
            if (existingValue != null && !((String)existingValue).equals(nodeValue)) {
                this.getValidator().throwPersistenceUnitMetadataConflict(key);
            }
            puDefaults.put(key, nodeValue);
        } else {
            puDefaults.put(key, "");
        }
    }

    public void processPersistenceUnitMetadata(AbstractSession session, Collection mappingStreams, Collection streamFileNames, Collection<Class> entities) {
        this.m_session = session;
        Boolean cascadePersist = null;
        Boolean metadataComplete = null;
        HashMap<String, Serializable> puDefaults = new HashMap<String, Serializable>();
        ArrayList<String> defaultListeners = new ArrayList<String>();
        HashMap<String, Node> defaultListenerEventMethods = new HashMap<String, Node>();
        if (!mappingStreams.isEmpty()) {
            puDefaults.put("entity-listeners", defaultListeners);
            Iterator streamFileNamesIt = streamFileNames.iterator();
            Iterator mapIt = mappingStreams.iterator();
            while (mapIt.hasNext()) {
                NodeList listenerNodes;
                this.m_helper = new XMLHelper((InputStream)mapIt.next(), (String)streamFileNamesIt.next(), this.m_loader);
                Node contextNode = this.m_helper.getNode(new String[]{"entity-mappings", "persistence-unit-metadata"});
                if (contextNode == null) continue;
                Node result = this.m_helper.getNode(contextNode, "xml-mapping-metadata-complete");
                if (result == null) {
                    if (metadataComplete == null) {
                        metadataComplete = false;
                    } else if (metadataComplete.booleanValue()) {
                        this.getValidator().throwPersistenceUnitMetadataConflict("xml-mapping-metadata-complete");
                    }
                } else if (metadataComplete == null) {
                    metadataComplete = true;
                    puDefaults.put("xml-mapping-metadata-complete", Boolean.valueOf(true));
                } else if (!metadataComplete.booleanValue()) {
                    this.getValidator().throwPersistenceUnitMetadataConflict("xml-mapping-metadata-complete");
                }
                if ((contextNode = this.m_helper.getNode(contextNode, "persistence-unit-defaults")) == null) continue;
                this.processPersistenceUnitDefault("access", contextNode, puDefaults);
                this.m_persistenceUnitAccess = (String)puDefaults.get("access");
                this.processPersistenceUnitDefault("schema", contextNode, puDefaults);
                this.m_persistenceUnitSchema = (String)puDefaults.get("schema");
                this.processPersistenceUnitDefault("catalog", contextNode, puDefaults);
                this.m_persistenceUnitCatalog = (String)puDefaults.get("catalog");
                result = this.m_helper.getNode(contextNode, "cascade-persist");
                if (result == null) {
                    if (cascadePersist == null) {
                        cascadePersist = false;
                    } else if (cascadePersist.booleanValue()) {
                        this.getValidator().throwPersistenceUnitMetadataConflict("cascade-persist");
                    }
                } else if (cascadePersist == null) {
                    cascadePersist = true;
                    puDefaults.put("cascade-persist", Boolean.valueOf(true));
                } else if (!cascadePersist.booleanValue()) {
                    this.getValidator().throwPersistenceUnitMetadataConflict("cascade-persist");
                }
                if ((listenerNodes = this.m_helper.getNodes(contextNode, "entity-listeners", "entity-listener")) == null || listenerNodes.getLength() <= 0) continue;
                int listenerCount = listenerNodes.getLength();
                for (int i = 0; i < listenerCount; ++i) {
                    Node listenerNode = listenerNodes.item(i);
                    String listenerClassName = this.m_helper.getClassNameForNode(listenerNode);
                    defaultListeners.add(listenerClassName);
                    HashMap eventMethods = new HashMap();
                    this.processEventMethodNames(eventMethods, listenerNode);
                    defaultListenerEventMethods.put(listenerClassName, (Node)((Object)eventMethods));
                }
            }
        }
        if (!entities.isEmpty()) {
            for (Class entityClass : entities) {
                XMLDescriptor descriptor = new XMLDescriptor(entityClass, null);
                this.m_session.getProject().addDescriptor(descriptor.getDescriptor());
                this.getDescriptorMetadataMap().put(entityClass, descriptor);
                descriptor.setXmlAccess(this.m_persistenceUnitAccess);
                descriptor.setSchema(this.m_persistenceUnitSchema);
                descriptor.setCatalog(this.m_persistenceUnitCatalog);
                if (puDefaults.get("cascade-persist") != null) {
                    descriptor.setShouldUseCascadePersist(true);
                }
                this.processDefaultListeners(defaultListeners, defaultListenerEventMethods, descriptor);
                descriptor.setShouldIgnoreAnnotations(puDefaults.get("xml-mapping-metadata-complete") != null);
            }
        }
    }

    protected MetadataJoinColumn processPrimaryKeyJoinColumnNode(Node pkJoinColNode, String sourceTable, String targetTable, MetadataDescriptor dmd) {
        String name = this.m_helper.getNodeValue(pkJoinColNode, "@name");
        String referencedColumnName = this.m_helper.getNodeValue(pkJoinColNode, "@referenced-column-name");
        String columnDefinition = this.m_helper.getNodeValue(pkJoinColNode, "@column-definition");
        return this.processPrimaryKeyJoinColumn(name, referencedColumnName, columnDefinition, sourceTable, targetTable, dmd);
    }

    @Override
    protected ArrayList processPrimaryKeyJoinColumns(Object[] pkJoinCols, String sourceTableName, String targetTableName, MetadataDescriptor dmd) {
        ArrayList<MetadataJoinColumn> joinColumnDetails = new ArrayList<MetadataJoinColumn>();
        for (int i = 0; i < pkJoinCols.length; ++i) {
            joinColumnDetails.add(this.processPrimaryKeyJoinColumnNode((Node)pkJoinCols[i], sourceTableName, targetTableName, dmd));
        }
        return joinColumnDetails;
    }

    protected ArrayList processPrimaryKeyJoinColumns(String sourceTable, String targetTable, Object element, MetadataDescriptor descriptor) {
        Class entityClass = descriptor.getJavaClass();
        Node entityNode = this.m_helper.locateEntityNode(entityClass);
        Node node = element instanceof String ? this.m_helper.locateNodeForAttribute(entityNode, (String)element) : entityNode;
        ArrayList<MetadataJoinColumn> joinColumnDetails = new ArrayList<MetadataJoinColumn>();
        NodeList primaryKeyJoinColumns = this.m_helper.getNodes(node, "primary-key-join-column");
        if (descriptor.hasCompositePrimaryKey()) {
            if (primaryKeyJoinColumns == null || primaryKeyJoinColumns.getLength() != descriptor.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(entityClass);
            }
        } else if (primaryKeyJoinColumns != null && primaryKeyJoinColumns.getLength() > 1) {
            this.getValidator().throwExcessivePrimaryKeyJoinColumnsSpecified(entityClass);
        }
        if (primaryKeyJoinColumns != null) {
            int columnCount = primaryKeyJoinColumns.getLength();
            for (int i = 0; i < columnCount; ++i) {
                Node pkJoinColumnNode = primaryKeyJoinColumns.item(i);
                String name = this.m_helper.getNodeValue(pkJoinColumnNode, "@name");
                String referencedColumnName = this.m_helper.getNodeValue(pkJoinColumnNode, "@referenced-column-name");
                String columnDefinition = this.m_helper.getNodeValue(pkJoinColumnNode, "@column-definition");
                joinColumnDetails.add(this.processPrimaryKeyJoinColumn(name, referencedColumnName, columnDefinition, sourceTable, targetTable, descriptor));
            }
        }
        this.addJoinColumnDefault(joinColumnDetails, sourceTable, targetTable, descriptor);
        return joinColumnDetails;
    }

    protected HashMap processQueryHints(Node queryNode) {
        HashMap<String, String> hintMap = new HashMap<String, String>();
        NodeList hints = this.m_helper.getNodes(queryNode, "hint");
        if (hints != null) {
            int hintCount = hints.getLength();
            for (int i = 0; i < hintCount; ++i) {
                Node hintNode = hints.item(i);
                String hintName = this.m_helper.getNodeValue(hintNode, "@name");
                String hintValue = this.m_helper.getNodeValue(hintNode, "@value");
                if (hintValue.equals("")) continue;
                hintMap.put(hintName, hintValue);
            }
        }
        return hintMap;
    }

    protected void processSecondaryTables(Node entityNode, XMLDescriptor descriptor) {
        NodeList secondaryTables = this.m_helper.getNodes(entityNode, "secondary-table");
        if (secondaryTables != null) {
            int tableCount = secondaryTables.getLength();
            for (int i = 0; i < tableCount; ++i) {
                Node tableNode = secondaryTables.item(i);
                String tableName = this.m_helper.getNodeValue(tableNode, "@name");
                String schema = this.m_helper.getNodeValue(tableNode, "@schema");
                String catalog = this.m_helper.getNodeValue(tableNode, "@catalog");
                DatabaseTable dbTable = this.processSecondaryTable(tableName, schema, catalog, this.getPrimaryKeyJoinColumns(tableNode), descriptor);
                this.processUniqueConstraints(tableNode, dbTable);
            }
        }
    }

    @Override
    protected void processSequenceGenerator(MetadataAccessor accessor) {
        this.processSequenceGenerator(((XMLAccessor)accessor).getSequenceGeneratorNode());
    }

    protected void processSequenceGenerator(Node node) {
        if (node != null) {
            String name = this.m_helper.getNodeValue(node, "@name");
            if (name.equals("SEQ_GEN_TABLE")) {
                this.getValidator().throwSequenceGeneratorUsingAReservedName("SEQ_GEN_TABLE", this.m_helper.getDocumentName());
            } else {
                MetadataSequenceGenerator sequenceGenerator = new MetadataSequenceGenerator(name, this.m_helper.getDocumentName());
                sequenceGenerator.setSequenceName(this.m_helper.getNodeValue(node, "@sequence-name", sequenceGenerator.getName()));
                sequenceGenerator.setInitialValue(this.m_helper.getNodeValue(node, "@initial-value", 0));
                sequenceGenerator.setAllocationSize(this.m_helper.getNodeValue(node, "@allocation-size", 50));
                this.processSequenceGenerator(sequenceGenerator);
            }
        }
    }

    protected void processSequenceGenerators() {
        NodeList sequenceGeneratorNodes = this.m_helper.getNodes("entity-mappings", "sequence-generator");
        if (sequenceGeneratorNodes != null) {
            int count = sequenceGeneratorNodes.getLength();
            for (int i = 0; i < count; ++i) {
                this.processSequenceGenerator(sequenceGeneratorNodes.item(i));
            }
        }
    }

    @Override
    protected void processSqlResultSetMappings(Class cls, MetadataDescriptor descriptor) {
        Node classNode = this.m_helper.locateNode(cls);
        if (classNode != null) {
            this.processSqlResultSetMappings(this.m_helper.getNodes(classNode, "sql-result-set-mapping"));
        }
    }

    protected void processSqlResultSetMappings(NodeList sqlResultSetNodes) {
        if (sqlResultSetNodes != null) {
            int nodeCount = sqlResultSetNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                this.m_session.getProject().addSQLResultSetMapping(this.createSQLResultSetMapping(sqlResultSetNodes.item(i)));
            }
        }
    }

    protected void processTable(Node node, XMLDescriptor descriptor) {
        if (descriptor.ignoreTableAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_TABLE, descriptor.getJavaClass());
        } else {
            Node tableNode = this.m_helper.getNode(node, "table");
            if (tableNode != null) {
                String tableName = this.m_helper.getNodeValue(tableNode, "@name");
                String schema = this.m_helper.getNodeValue(tableNode, "@schema");
                String catalog = this.m_helper.getNodeValue(tableNode, "@catalog");
                DatabaseTable dbTable = this.buildPrimaryTable(tableName, catalog, schema, descriptor);
                this.processUniqueConstraints(tableNode, dbTable);
            } else {
                this.processTableAnnotation(descriptor);
            }
        }
    }

    @Override
    protected void processTableGenerator(MetadataAccessor accessor) {
        this.processTableGenerator(((XMLAccessor)accessor).getTableGeneratorNode());
    }

    protected void processTableGenerator(Node node) {
        if (node != null) {
            String name = this.m_helper.getNodeValue(node, "@name");
            if (name.equals("SEQ_GEN_SEQUENCE")) {
                this.getValidator().throwTableGeneratorUsingAReservedName("SEQ_GEN_SEQUENCE", this.m_helper.getDocumentName());
            } else {
                MetadataTableGenerator tableGenerator = new MetadataTableGenerator(name, this.m_helper.getDocumentName());
                tableGenerator.setPkColumnName(this.m_helper.getNodeValue(node, "@pk-column-name"));
                tableGenerator.setValueColumnName(this.m_helper.getNodeValue(node, "@value-column-name"));
                tableGenerator.setPkColumnValue(this.m_helper.getNodeValue(node, "@pk-column-value"));
                tableGenerator.setInitialValue(this.m_helper.getNodeValue(node, "@initial-value", 0));
                tableGenerator.setAllocationSize(this.m_helper.getNodeValue(node, "@allocation-size", 50));
                tableGenerator.setTable(this.m_helper.getNodeValue(node, "@table"));
                tableGenerator.setSchema(this.m_helper.getNodeValue(node, "@schema", this.m_entityMappingsSchema));
                tableGenerator.setCatalog(this.m_helper.getNodeValue(node, "@catalog", this.m_entityMappingsCatalog));
                tableGenerator.setUniqueConstraints(this.processUniqueConstraints(node, null));
                this.processTableGenerator(tableGenerator);
            }
        }
    }

    protected void processTableGenerators() {
        NodeList tableGeneratorNodes = this.m_helper.getNodes("entity-mappings", "table-generator");
        if (tableGeneratorNodes != null) {
            int count = tableGeneratorNodes.getLength();
            for (int i = 0; i < count; ++i) {
                this.processTableGenerator(tableGeneratorNodes.item(i));
            }
        }
    }

    protected ArrayList<String> processUniqueConstraints(Node tableNode, DatabaseTable table) {
        NodeList uniqueConstraintNodes;
        if (table == null) {
            table = new DatabaseTable();
        }
        if ((uniqueConstraintNodes = this.m_helper.getNodes(tableNode, "unique-constraint")) != null) {
            int constraintCount = uniqueConstraintNodes.getLength();
            for (int i = 0; i < constraintCount; ++i) {
                NodeList columnNameNodes = this.m_helper.getNodes(uniqueConstraintNodes.item(i), "column-name", "text()");
                if (columnNameNodes == null) continue;
                int columnCount = columnNameNodes.getLength();
                for (int k = 0; k < columnCount; ++k) {
                    String columnName = columnNameNodes.item(k).getNodeValue();
                    if (columnName == null || columnName.equals("")) continue;
                    table.addUniqueConstraint(columnName);
                }
            }
        }
        return new ArrayList<String>(table.getUniqueConstraints());
    }
}

