/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.util.ArrayList;
import java.util.List;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDescriptor
extends MetadataDescriptor {
    private XMLHelper m_helper;

    public XMLDescriptor(Class javaClass, XMLHelper xmlHelper) {
        super(javaClass);
        this.m_helper = xmlHelper;
    }

    public XMLDescriptor(ClassDescriptor descriptor, Class javaClass) {
        super(descriptor, javaClass);
        this.m_helper = null;
    }

    public XMLDescriptor(ClassDescriptor descriptor, Class javaClass, XMLHelper xmlHelper) {
        super(descriptor, javaClass);
        this.m_helper = xmlHelper;
    }

    public void addXMLMappedSuperclass(Class mappedSuperclass) {
        this.getMappedSuperclasses().add(mappedSuperclass);
    }

    @Override
    public String getDiscriminatorValue() {
        String discriminatorValue = null;
        Node entityNode = this.m_helper.locateEntityNode(this.getJavaClass());
        String result = this.m_helper.getNodeValue(entityNode, new String[]{"discriminator-value", "text()"});
        if (!result.equals("")) {
            discriminatorValue = result;
        }
        return discriminatorValue;
    }

    @Override
    public List<Class> getMappedSuperclasses() {
        if (this.m_mappedSuperclasses == null) {
            this.m_mappedSuperclasses = new ArrayList();
            for (Class parent = this.getJavaClass().getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
                if (this.hasMappedSuperclassTag(parent)) {
                    this.m_mappedSuperclasses.add(parent);
                    continue;
                }
                if (!this.hasMappedSuperclassAnnotation(parent)) continue;
                this.m_mappedSuperclasses.add(parent);
            }
        }
        return this.m_mappedSuperclasses;
    }

    public void handleComplexDefaultPrimaryKeyUsage(DatabaseField dbField) {
        if (this.isDefaultPrimaryKeySet()) {
            this.getFieldsWithComplexDefaultPrimaryKeySet().add(dbField);
        }
    }

    public void handleDefaultPrimaryKeyUsage(DatabaseField dbField) {
        if (this.isDefaultPrimaryKeySet()) {
            this.getFieldsWithDefaultPrimaryKeySet().add(dbField);
        }
    }

    @Override
    protected boolean hasEntityTag(Class cls) {
        return this.m_helper.locateEntityNode(cls) != null;
    }

    @Override
    protected boolean hasInheritanceTag(Class entityClass) {
        return this.m_helper.nodeHasInheritance(this.m_helper.locateEntityNode(entityClass));
    }

    protected boolean hasMappedSuperclassTag(Class cls) {
        return this.m_helper.locateMappedSuperclassNode(cls) != null;
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return this.m_helper.nodeHasPrimaryKeyJoinColumns(this.m_helper.locateNode(this.m_javaClass));
    }

    public void setHelper(XMLHelper helper) {
        this.m_helper = helper;
    }

    public void setXmlAccess(String access) {
        if (access.equals("FIELD")) {
            this.setIsXmlFieldAccess();
        } else if (access.equals("PROPERTY")) {
            this.setIsXmlPropertyAccess();
        }
    }
}

