/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;

public class LiteralExpression
extends Expression {
    protected String value;
    protected Expression localBase;

    public LiteralExpression() {
    }

    public LiteralExpression(String newValue, Expression baseExpression) {
        this.value = newValue;
        this.localBase = baseExpression;
    }

    public String descriptionOfNodeType() {
        return "Literal";
    }

    public ExpressionBuilder getBuilder() {
        return this.getLocalBase().getBuilder();
    }

    protected Expression getLocalBase() {
        return this.localBase;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isLiteralExpression() {
        return true;
    }

    protected void postCopyIn(Dictionary alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.localBase = this.localBase.copiedVersionFrom(alreadyDone);
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printString(this.value);
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter printer) {
        this.printSQL(printer);
    }

    public Expression rebuildOn(Expression newBase) {
        LiteralExpression result = (LiteralExpression)this.clone();
        ((Expression)result).setLocalBase(this.getLocalBase().rebuildOn(newBase));
        return result;
    }

    public void setLocalBase(Expression e) {
        this.localBase = e;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        return (Expression)this.clone();
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean isObjectUnregistered) {
        return this.getLocalBase().getFieldValue(this.getValue());
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getValue().toString());
    }
}

