/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.essentials.tools.schemaframework.FieldDefinition;
import oracle.toplink.essentials.tools.schemaframework.ForeignKeyConstraint;
import oracle.toplink.essentials.tools.schemaframework.UniqueKeyConstraint;

public class TableDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();
    protected Vector foreignKeys = new Vector();
    protected Vector uniqueKeys = new Vector();
    protected String creationPrefix = "CREATE TABLE ";
    protected String creationSuffix = "";
    private boolean createSQLFiles;

    public void addField(String fieldName, Class type) {
        this.addField(new FieldDefinition(fieldName, type));
    }

    public void addField(String fieldName, Class type, int fieldSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize));
    }

    public void addField(String fieldName, Class type, int fieldSize, int fieldSubSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize, fieldSubSize));
    }

    public void addField(String fieldName, String typeName) {
        this.addField(new FieldDefinition(fieldName, typeName));
    }

    public void addField(FieldDefinition field) {
        this.getFields().addElement(field);
    }

    public void addForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        ForeignKeyConstraint foreignKey = new ForeignKeyConstraint(name, sourceField, targetField, targetTable);
        this.addForeignKeyConstraint(foreignKey);
    }

    public void addUniqueKeyConstraint(String name, String sourceField) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceField);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint foreignKey) {
        this.getForeignKeys().addElement(foreignKey);
    }

    public void addUniqueKeyConstraint(UniqueKeyConstraint uniqueKey) {
        this.getUniqueKeys().addElement(uniqueKey);
    }

    public void addIdentityField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addIdentityField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public Writer buildConstraintCreationWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(foreignKey.getName() + " ");
            }
            foreignKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + foreignKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildConstraintDeletionWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + foreignKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintCreationWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(uniqueKey.getName() + " ");
            }
            uniqueKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + uniqueKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintDeletionWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + uniqueKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public String getCreationPrefix() {
        return this.creationPrefix;
    }

    public void setCreationPrefix(String creationPrefix) {
        this.creationPrefix = creationPrefix;
    }

    public String getCreationSuffix() {
        return this.creationSuffix;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.creationSuffix = creationSuffix;
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write(this.getCreationPrefix() + this.getFullName() + " (");
            Enumeration fieldsEnum = this.getFields().elements();
            while (fieldsEnum.hasMoreElements()) {
                FieldDefinition field = (FieldDefinition)fieldsEnum.nextElement();
                field.appendDBString(writer, session, this);
                if (!fieldsEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            Vector keyFields = this.getPrimaryKeyFieldNames();
            if (!keyFields.isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(", ");
                if (session.getPlatform().requiresNamedPrimaryKeyConstraints()) {
                    writer.write("CONSTRAINT " + this.getFullName() + "_PK ");
                }
                writer.write("PRIMARY KEY (");
                Enumeration keyEnum = keyFields.elements();
                while (keyEnum.hasMoreElements()) {
                    writer.write((String)keyEnum.nextElement());
                    if (!keyEnum.hasMoreElements()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            writer.write(")");
            if (this.getCreationSuffix().length() > 0) {
                writer.write(this.getCreationSuffix());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TABLE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    protected void buildFieldTypes(AbstractSession session) {
        this.buildForeignFieldTypes(session);
        this.buildUniqueFieldTypes(session);
    }

    private void buildUniqueFieldTypes(AbstractSession session) {
        Vector uniqueKeysClone = (Vector)this.getUniqueKeys().clone();
        Object[] uniqueKeysArray = uniqueKeysClone.toArray();
        this.setUniqueKeys(new Vector());
        int serialNumber = 0;
        for (Object uniqueKeys : uniqueKeysArray) {
            String[] columnNames;
            UniqueKeyConstraint uniqueKeyConstraint = this.buildUniqueKeyConstraint(this, serialNumber++, session.getPlatform());
            for (String columnName : columnNames = (String[])uniqueKeys) {
                uniqueKeyConstraint.addSourceField(columnName);
            }
            this.addUniqueKeyConstraint(uniqueKeyConstraint);
        }
    }

    private void buildForeignFieldTypes(AbstractSession session) {
        Hashtable fieldTypes = session.getPlatform().getClassTypes();
        FieldDefinition field = null;
        Object dbField = null;
        Vector foreignKeysClone = (Vector)this.getForeignKeys().clone();
        this.setForeignKeys(new Vector());
        Enumeration enumtr = this.getFields().elements();
        while (enumtr.hasMoreElements()) {
            field = (FieldDefinition)enumtr.nextElement();
            if (field.getForeignKeyFieldName() != null) {
                this.addForeignKeyConstraint(this.buildForeignKeyConstraint(field, this, session.getPlatform()));
            }
            if (field.getType() != null) continue;
            field.setType((Class)fieldTypes.get(field.getTypeName()));
            if (field.getType() == null) continue;
            field.setTypeName(null);
        }
        if (this.getForeignKeys().isEmpty()) {
            this.setForeignKeys(foreignKeysClone);
        }
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition field, TableDefinition table, DatabasePlatform platform) {
        Vector<String> sourceFields = new Vector<String>();
        Vector<String> targetFields = new Vector<String>();
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        DatabaseField tempTargetField = new DatabaseField(field.getForeignKeyFieldName());
        DatabaseField tempSourceField = new DatabaseField(field.getName());
        sourceFields.addElement(tempSourceField.getName());
        targetFields.addElement(tempTargetField.getName());
        fkConstraint.setSourceFields(sourceFields);
        fkConstraint.setTargetFields(targetFields);
        fkConstraint.setTargetTable(tempTargetField.getTableName());
        String tempName = this.buildForeignKeyConstraintName(table.getName(), tempSourceField.getName(), platform.getMaxForeignKeyNameSize());
        fkConstraint.setName(tempName);
        return fkConstraint;
    }

    protected String buildForeignKeyConstraintName(String tableName, String fieldName, int maximumNameLength) {
        String onlyAlphaNumericFieldName;
        String onlyAlphaNumericTableName;
        String foreignKeyName = "FK_" + tableName + "_" + fieldName;
        if (foreignKeyName.length() > maximumNameLength && (foreignKeyName = tableName + "_" + fieldName).length() > maximumNameLength && (foreignKeyName = Helper.removeAllButAlphaNumericToFit(tableName + fieldName, maximumNameLength)).length() > maximumNameLength && (foreignKeyName = Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(tableName, 0), onlyAlphaNumericFieldName = Helper.removeAllButAlphaNumericToFit(fieldName, 0), maximumNameLength)).length() > maximumNameLength) {
            String shortenedFieldName = Helper.removeVowels(onlyAlphaNumericFieldName);
            String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
            foreignKeyName = Helper.truncate(shortenedTableName, maximumNameLength - shortenedFieldName.length()) + shortenedFieldName;
        }
        return foreignKeyName;
    }

    protected UniqueKeyConstraint buildUniqueKeyConstraint(TableDefinition table, int serialNumber, DatabasePlatform platform) {
        UniqueKeyConstraint unqConstraint = new UniqueKeyConstraint();
        String tempName = this.buildUniqueKeyConstraintName(table.getName(), serialNumber, platform.getMaxUniqueKeyNameSize());
        unqConstraint.setName(tempName);
        return unqConstraint;
    }

    protected String buildUniqueKeyConstraintName(String tableName, int serialNumber, int maximumNameLength) {
        String onlyAlphaNumericTableName;
        String uniqueKeyName = "UNQ_" + tableName + "_" + serialNumber;
        if (uniqueKeyName.length() > maximumNameLength && (uniqueKeyName = tableName).length() > maximumNameLength && (uniqueKeyName = Helper.removeAllButAlphaNumericToFit(tableName + serialNumber, maximumNameLength)).length() > maximumNameLength && (uniqueKeyName = Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(tableName, 0), "", maximumNameLength)).length() > maximumNameLength) {
            String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
            uniqueKeyName = Helper.truncate(shortenedTableName, maximumNameLength - shortenedTableName.length());
        }
        return uniqueKeyName;
    }

    public Object clone() {
        TableDefinition clone = (TableDefinition)super.clone();
        if (this.fields != null) {
            clone.setFields(new Vector(this.fields.size()));
            Enumeration enumtr = this.getFields().elements();
            while (enumtr.hasMoreElements()) {
                FieldDefinition fieldDef = (FieldDefinition)enumtr.nextElement();
                clone.addField((FieldDefinition)fieldDef.clone());
            }
        }
        if (this.foreignKeys != null) {
            clone.setForeignKeys((Vector)this.foreignKeys.clone());
        }
        if (this.uniqueKeys != null) {
            clone.setUniqueKeys((Vector)this.uniqueKeys.clone());
        }
        return clone;
    }

    public void createConstraints(AbstractSession session, Writer schemaWriter) throws TopLinkException {
        if (schemaWriter == null) {
            this.createConstraintsOnDatabase(session);
        } else {
            this.createForeignConstraints(session, schemaWriter);
            this.createUniqueContraints(session, schemaWriter);
        }
    }

    private void createUniqueContraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        Enumeration uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = (UniqueKeyConstraint)uniqueKeysEnum.nextElement();
            this.buildUniqueConstraintCreationWriter(session, uniqueKey, schemaWriter).toString();
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    private void createForeignConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        Enumeration foreignKeysEnum = this.getForeignKeys().elements();
        while (foreignKeysEnum.hasMoreElements()) {
            ForeignKeyConstraint foreignKey = (ForeignKeyConstraint)foreignKeysEnum.nextElement();
            this.buildConstraintCreationWriter(session, foreignKey, schemaWriter).toString();
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    public void createConstraintsOnDatabase(AbstractSession session) throws TopLinkException {
        this.createForeignConstraintsOnDatabase(session);
        this.createUniqueConstraintsOnDatabase(session);
    }

    private void createUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = (UniqueKeyConstraint)uniqueKeysEnum.nextElement();
            session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintCreationWriter(session, uniqueKey, new StringWriter()).toString()));
        }
    }

    private void createForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeys().isEmpty()) {
            return;
        }
        Enumeration foreignKeysEnum = this.getForeignKeys().elements();
        while (foreignKeysEnum.hasMoreElements()) {
            ForeignKeyConstraint foreignKey = (ForeignKeyConstraint)foreignKeysEnum.nextElement();
            session.executeNonSelectingCall(new SQLCall(this.buildConstraintCreationWriter(session, foreignKey, new StringWriter()).toString()));
        }
    }

    public String deletionStringFor(DatabaseAccessor accessor) {
        return "DROP TABLE " + this.getName();
    }

    public void dropConstraints(AbstractSession session, Writer schemaWriter) throws TopLinkException {
        if (schemaWriter == null) {
            this.dropConstraintsOnDatabase(session);
        } else {
            Enumeration foreignKeysEnum = this.getForeignKeys().elements();
            while (foreignKeysEnum.hasMoreElements()) {
                ForeignKeyConstraint foreignKey = (ForeignKeyConstraint)foreignKeysEnum.nextElement();
                this.buildConstraintDeletionWriter(session, foreignKey, schemaWriter).toString();
                try {
                    if (this.createSQLFiles) {
                        schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                    }
                    schemaWriter.write("\n");
                }
                catch (IOException exception) {
                    throw ValidationException.fileError(exception);
                }
            }
            Enumeration uniqueKeysEnum = this.getUniqueKeys().elements();
            while (uniqueKeysEnum.hasMoreElements()) {
                UniqueKeyConstraint uniqueKey = (UniqueKeyConstraint)uniqueKeysEnum.nextElement();
                this.buildUniqueConstraintDeletionWriter(session, uniqueKey, schemaWriter).toString();
                try {
                    if (this.createSQLFiles) {
                        schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                    }
                    schemaWriter.write("\n");
                }
                catch (IOException exception) {
                    throw ValidationException.fileError(exception);
                }
            }
        }
    }

    public void dropConstraintsOnDatabase(AbstractSession session) throws TopLinkException {
        this.dropForeignConstraintsOnDatabase(session);
        this.dropUniqueConstraintsOnDatabase(session);
    }

    private void dropUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = (UniqueKeyConstraint)uniqueKeysEnum.nextElement();
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintDeletionWriter(session, uniqueKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    private void dropForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeys().isEmpty()) {
            return;
        }
        Enumeration foreignKeysEnum = this.getForeignKeys().elements();
        while (foreignKeysEnum.hasMoreElements()) {
            ForeignKeyConstraint foreignKey = (ForeignKeyConstraint)foreignKeysEnum.nextElement();
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildConstraintDeletionWriter(session, foreignKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getForeignKeys() {
        return this.foreignKeys;
    }

    public Vector getUniqueKeys() {
        return this.uniqueKeys;
    }

    public Vector getPrimaryKeyFieldNames() {
        Vector<String> keyNames = new Vector<String>();
        Enumeration fieldEnum = this.getFields().elements();
        while (fieldEnum.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)fieldEnum.nextElement();
            if (!field.isPrimaryKey()) continue;
            keyNames.addElement(field.getName());
        }
        return keyNames;
    }

    public void setFields(Vector fields) {
        this.fields = fields;
    }

    public void setForeignKeys(Vector foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public void setUniqueKeys(Vector uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }
}

