/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Debug;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.BlockingQueueDispatchAuditor;
import gov.nist.javax.sip.stack.QueuedMessageDispatchBase;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class PipelinedMsgParser
implements Runnable {
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private ConcurrentHashMap<String, CallIDOrderingStructure> messagesOrderingMap = new ConcurrentHashMap();
    boolean isRunning = false;
    private static int uid = 0;
    private static ExecutorService postParseExecutor = null;
    public static BlockingQueue<Runnable> staticQueue;
    public static BlockingQueueDispatchAuditor staticQueueAuditor;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++ % 99999999;
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        if (staticQueueAuditor != null) {
            staticQueueAuditor.setLogger(sipStack.getStackLogger());
        }
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(sipStack, mhandler, in, false, maxMsgSize);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread(p);
        mythread.setName(this.mythread.getName());
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        while (true) {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            char ch = (char)(i & 0xFF);
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            }
            if (ch == '\n') break;
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        return new String(lineBuffer, 0, counter, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Pipeline inputStream = this.rawInputStream;
        StackLogger stackLogger = this.sipStack.getStackLogger();
        try {
            this.isRunning = true;
            while (this.isRunning) {
                SIPMessage sipMessage;
                block66: {
                    ConcurrentHashMap<String, CallIDOrderingStructure> concurrentHashMap;
                    String line1;
                    this.sizeCounter = this.maxMessageSize;
                    StringBuffer inputBuffer = new StringBuffer();
                    if (Debug.parserDebug) {
                        Debug.println("Starting parse!");
                    }
                    String line2 = null;
                    try {
                        while ((line1 = this.readLine(inputStream)).equals("\n")) {
                            if (!Debug.parserDebug) continue;
                            Debug.println("Discarding blank line. ");
                        }
                    }
                    catch (IOException ex) {
                        if (postParseExecutor != null && this.isRunning) {
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                            concurrentHashMap = this.messagesOrderingMap;
                            synchronized (concurrentHashMap) {
                                try {
                                    this.messagesOrderingMap.wait(64000L);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("got notified or the wait timed out after 64s for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                        }
                        this.rawInputStream.stopTimer();
                        if (this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("thread ending for threadname " + this.mythread.getName());
                        }
                        Debug.printStackTrace(ex);
                        Object var16_26 = null;
                        try {
                            this.cleanMessageOrderingMap();
                            if (!inputStream.isClosed()) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("ioexception on cleaning up " + this + " threadname " + this.mythread.getName());
                            }
                            InternalErrorHandler.handleException(e);
                        }
                        return;
                    }
                    inputBuffer.append(line1);
                    this.rawInputStream.startTimer();
                    Debug.println("Reading Input Stream");
                    try {
                        do {
                            line2 = this.readLine(inputStream);
                            inputBuffer.append(line2);
                        } while (!line2.trim().equals(""));
                    }
                    catch (IOException ex) {
                        if (postParseExecutor != null && this.isRunning) {
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                            concurrentHashMap = this.messagesOrderingMap;
                            synchronized (concurrentHashMap) {
                                try {
                                    this.messagesOrderingMap.wait(64000L);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("got notified or the wait timed out after 64s for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                        }
                        this.rawInputStream.stopTimer();
                        if (this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("thread ending for threadname " + this.mythread.getName());
                        }
                        Debug.printStackTrace(ex);
                        Object var16_27 = null;
                        try {
                            this.cleanMessageOrderingMap();
                            if (!inputStream.isClosed()) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("ioexception on cleaning up " + this + " threadname " + this.mythread.getName());
                            }
                            InternalErrorHandler.handleException(e);
                        }
                        return;
                    }
                    this.rawInputStream.stopTimer();
                    inputBuffer.append(line2);
                    MessageParser smp = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
                    smp.setParseExceptionListener(this.sipMessageListener);
                    smp.setReadBody(false);
                    sipMessage = null;
                    try {
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("About to parse : " + inputBuffer.toString());
                        }
                        if ((sipMessage = smp.parseSIPMessage(inputBuffer.toString().getBytes())) == null) {
                            this.rawInputStream.stopTimer();
                        }
                        break block66;
                    }
                    catch (ParseException ex) {
                        stackLogger.logError("Detected a parse error", ex);
                    }
                    continue;
                }
                if (Debug.debug) {
                    Debug.println("Completed parsing message");
                }
                ContentLength cl = (ContentLength)sipMessage.getContentLength();
                int contentLength = 0;
                contentLength = cl != null ? cl.getContentLength() : 0;
                if (Debug.debug) {
                    Debug.println("contentLength " + contentLength);
                }
                if (contentLength == 0) {
                    sipMessage.removeContent();
                } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                    int readlength;
                    byte[] message_body = new byte[contentLength];
                    for (int nread = 0; nread < contentLength; nread += readlength) {
                        Object var14_25;
                        this.rawInputStream.startTimer();
                        try {
                            try {
                                readlength = inputStream.read(message_body, nread, contentLength - nread);
                                if (readlength > 0) {
                                } else {
                                    var14_25 = null;
                                    this.rawInputStream.stopTimer();
                                    break;
                                }
                                var14_25 = null;
                                this.rawInputStream.stopTimer();
                                continue;
                            }
                            catch (IOException ex) {
                                stackLogger.logError("Exception Reading Content", ex);
                                var14_25 = null;
                                this.rawInputStream.stopTimer();
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            var14_25 = null;
                            this.rawInputStream.stopTimer();
                            throw throwable;
                        }
                    }
                    sipMessage.setMessageContent(message_body);
                }
                if (this.sipMessageListener == null) continue;
                try {
                    CallIDOrderingStructure newCallIDOrderingStructure;
                    if (postParseExecutor == null) {
                        if (this.sipStack.sipEventInterceptor != null) {
                            this.sipStack.sipEventInterceptor.beforeMessage(sipMessage);
                        }
                        this.sipMessageListener.processMessage(sipMessage);
                        if (this.sipStack.sipEventInterceptor == null) continue;
                        this.sipStack.sipEventInterceptor.afterMessage(sipMessage);
                        continue;
                    }
                    String callId = sipMessage.getCallId().getCallId();
                    CallIDOrderingStructure orderingStructure = this.messagesOrderingMap.get(callId);
                    if (orderingStructure == null && (orderingStructure = this.messagesOrderingMap.putIfAbsent(callId, newCallIDOrderingStructure = new CallIDOrderingStructure())) == null) {
                        orderingStructure = newCallIDOrderingStructure;
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("new CallIDOrderingStructure added for message " + sipMessage);
                        }
                    }
                    CallIDOrderingStructure callIDOrderingStructure = orderingStructure;
                    callIDOrderingStructure.getMessagesForCallID().offer(sipMessage);
                    postParseExecutor.execute(new Dispatch(callIDOrderingStructure, callId));
                }
                catch (Exception ex) {
                    if (!this.sipStack.isLoggingEnabled(32)) break;
                    this.sipStack.getStackLogger().logDebug("error on processing... breaking " + this + " threadname " + this.mythread.getName());
                    break;
                }
            }
            Object var16_28 = null;
        }
        catch (Throwable throwable) {
            Object var16_29 = null;
            try {
                this.cleanMessageOrderingMap();
                if (!inputStream.isClosed()) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("ioexception on cleaning up " + this + " threadname " + this.mythread.getName());
                }
                InternalErrorHandler.handleException(e);
            }
            throw throwable;
        }
        try {
            this.cleanMessageOrderingMap();
            if (!inputStream.isClosed()) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("ioexception on cleaning up " + this + " threadname " + this.mythread.getName());
            }
            InternalErrorHandler.handleException(e);
        }
        if (this.sipStack.getStackLogger().isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("thread ending for threadname " + this.mythread.getName());
        }
    }

    public static void setPostParseExcutorSize(int threads, int timeout) {
        if (postParseExecutor != null) {
            postParseExecutor.shutdownNow();
        }
        if (staticQueueAuditor != null) {
            try {
                staticQueueAuditor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (postParseExecutor == null) {
            if (threads <= 0) {
                postParseExecutor = null;
            } else {
                if (staticQueueAuditor != null) {
                    staticQueueAuditor.stop();
                }
                staticQueue = new LinkedBlockingQueue<Runnable>();
                postParseExecutor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, staticQueue, new NamedThreadFactory());
                if (timeout > 0) {
                    staticQueueAuditor = new BlockingQueueDispatchAuditor(staticQueue);
                    staticQueueAuditor.setTimeout(timeout);
                    staticQueueAuditor.start(2000);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            this.isRunning = false;
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Closing pipelinedmsgparser " + this + " threadname " + this.mythread.getName());
            }
            try {
                this.rawInputStream.close();
            }
            catch (IOException ex) {
                if (!this.sipStack.isLoggingEnabled(32)) break block7;
                this.sipStack.getStackLogger().logDebug("Couldn't close the rawInputStream " + this + " threadname " + this.mythread.getName() + " already closed ? " + this.rawInputStream.isClosed());
            }
        }
        if (postParseExecutor != null) {
            this.cleanMessageOrderingMap();
            Thread thread = this.mythread;
            synchronized (thread) {
                this.mythread.notifyAll();
                this.mythread.interrupt();
            }
        }
    }

    public static void shutdownTcpThreadpool() {
        if (postParseExecutor != null) {
            postParseExecutor.shutdown();
            postParseExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMessageOrderingMap() {
        this.messagesOrderingMap.clear();
        ConcurrentHashMap<String, CallIDOrderingStructure> concurrentHashMap = this.messagesOrderingMap;
        synchronized (concurrentHashMap) {
            this.messagesOrderingMap.notifyAll();
        }
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("cleaned the messagesOrderingMap " + this + " threadname " + this.mythread.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CallIDOrderingStructure {
        private Semaphore semaphore = new Semaphore(1, true);
        private Queue<SIPMessage> messagesForCallID = new ConcurrentLinkedQueue<SIPMessage>();

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public Queue<SIPMessage> getMessagesForCallID() {
            return this.messagesForCallID;
        }
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        static long threadNumber = 0L;

        public Thread newThread(Runnable arg0) {
            Thread thread = new Thread(arg0);
            thread.setName("SIP-TCP-Core-PipelineThreadpool-" + threadNumber++ % 999999999L);
            return thread;
        }
    }

    public class Dispatch
    implements Runnable,
    QueuedMessageDispatchBase {
        CallIDOrderingStructure callIDOrderingStructure;
        String callId;
        long time;

        public Dispatch(CallIDOrderingStructure callIDOrderingStructure, String callId) {
            this.callIDOrderingStructure = callIDOrderingStructure;
            this.callId = callId;
            this.time = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SIPMessage message;
            block28: {
                Semaphore semaphore = this.callIDOrderingStructure.getSemaphore();
                Queue<SIPMessage> messagesForCallID = this.callIDOrderingStructure.getMessagesForCallID();
                if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                    ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.beforeMessage(messagesForCallID.peek());
                }
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e) {
                    PipelinedMsgParser.this.sipStack.getStackLogger().logError("Semaphore acquisition for callId " + this.callId + " interrupted", e);
                }
                message = messagesForCallID.poll();
                if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                    PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("semaphore acquired for message " + message + " threadname " + PipelinedMsgParser.this.mythread.getName());
                }
                try {
                    try {
                        PipelinedMsgParser.this.sipMessageListener.processMessage(message);
                    }
                    catch (Exception e) {
                        PipelinedMsgParser.this.sipStack.getStackLogger().logError("Error occured processing message", e);
                        Object var6_6 = null;
                        if (messagesForCallID.isEmpty()) {
                            PipelinedMsgParser.this.messagesOrderingMap.remove(this.callId);
                            if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                                PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("CallIDOrderingStructure removed for message " + this.callId);
                            }
                        }
                        if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                            PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("releasing semaphore for message " + message + " threadname " + PipelinedMsgParser.this.mythread.getName());
                        }
                        semaphore.release();
                        if (PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) {
                            ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                            synchronized (concurrentHashMap) {
                                PipelinedMsgParser.this.messagesOrderingMap.notify();
                            }
                        }
                        if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                            ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.afterMessage(message);
                        }
                        break block28;
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (messagesForCallID.isEmpty()) {
                        PipelinedMsgParser.this.messagesOrderingMap.remove(this.callId);
                        if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                            PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("CallIDOrderingStructure removed for message " + this.callId);
                        }
                    }
                    if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                        PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("releasing semaphore for message " + message + " threadname " + PipelinedMsgParser.this.mythread.getName());
                    }
                    semaphore.release();
                    if (PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) {
                        ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                        synchronized (concurrentHashMap) {
                            PipelinedMsgParser.this.messagesOrderingMap.notify();
                        }
                    }
                    if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                        ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.afterMessage(message);
                    }
                    throw throwable;
                }
                if (messagesForCallID.isEmpty()) {
                    PipelinedMsgParser.this.messagesOrderingMap.remove(this.callId);
                    if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                        PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("CallIDOrderingStructure removed for message " + this.callId);
                    }
                }
                if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                    PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("releasing semaphore for message " + message + " threadname " + PipelinedMsgParser.this.mythread.getName());
                }
                semaphore.release();
                if (PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) {
                    ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                    synchronized (concurrentHashMap) {
                        PipelinedMsgParser.this.messagesOrderingMap.notify();
                    }
                }
                if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                    ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.afterMessage(message);
                }
            }
            if (PipelinedMsgParser.this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                PipelinedMsgParser.this.sipStack.getStackLogger().logDebug("dispatch task done on " + message + " threadname " + PipelinedMsgParser.this.mythread.getName());
            }
        }

        public long getReceptionTime() {
            return this.time;
        }
    }
}

